/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.NodeChooser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.SearchResult;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.NodeChooser.CNodeChooserTable;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Model.GraphSearcher;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.HtmlGenerator;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public final class CNodeChooserRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -7732373934467520210L;
    private static final Font DEFAULT_CELL_FONT = new Font(GuiHelper.getDefaultFont(), 0, 12);
    private static final Color DEFAULT_BACKGROUND = new Color(252, 252, 252);
    private static final Color SEARCH_HIT_BACKGROUND = new Color(252, 252, 200);
    private static final Color SELECTED_FOREGROUND = new Color(160, 0, 0);
    private static final Color UNSELECTED_FOREGROUND = new Color(0, 0, 0);
    private static final Color INVISIBLE_FOREGROUND = new Color(128, 128, 128);
    private static final String MONOSPACE_FONT = GuiHelper.getMonospaceFont();
    private final CNodeChooserTable m_table;
    private final ZyGraph m_graph;
    private final GraphSearcher m_searcher;

    public CNodeChooserRenderer(CNodeChooserTable cNodeChooserTable, ZyGraph zyGraph, GraphSearcher graphSearcher) {
        this.m_table = Preconditions.checkNotNull(cNodeChooserTable, "IE01770: Table can't be null.");
        this.m_graph = Preconditions.checkNotNull(zyGraph, "IE01771: Graph can't be null.");
        this.m_searcher = Preconditions.checkNotNull(graphSearcher, "IE01772: Graph searcher can't be null.");
        this.setOpaque(true);
    }

    private static String buildToolTip(ZyLabelContent zyLabelContent) {
        return HtmlGenerator.getHtml(zyLabelContent, MONOSPACE_FONT, true);
    }

    private static String getNodeText(INaviViewNode iNaviViewNode) {
        if (iNaviViewNode instanceof INaviFunctionNode) {
            return ((INaviFunctionNode)iNaviViewNode).getFunction().getName();
        }
        if (iNaviViewNode instanceof INaviCodeNode) {
            return ((INaviInstruction)Iterables.getFirst(((INaviCodeNode)iNaviViewNode).getInstructions(), null)).getAddress().toHexString();
        }
        if (iNaviViewNode instanceof INaviGroupNode) {
            return "GroupNode";
        }
        if (iNaviViewNode instanceof INaviTextNode) {
            return "Comment node";
        }
        throw new IllegalStateException("IE01152: Invalid node in node chooser");
    }

    private void calculateBackgroundColor(INaviViewNode iNaviViewNode) {
        List<SearchResult> list = this.m_searcher.getResults();
        for (SearchResult searchResult : list) {
            if (!(searchResult.getObject() instanceof NaviNode) || !((NaviNode)searchResult.getObject()).getRawNode().equals(iNaviViewNode)) continue;
            this.setBackground(SEARCH_HIT_BACKGROUND);
            return;
        }
    }

    private INaviViewNode getNode(int n2) {
        return this.m_graph.getRawView().getGraph().getNodes().get(n2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
        this.setFont(DEFAULT_CELL_FONT);
        INaviViewNode iNaviViewNode = this.getNode(this.m_table.modelIndex(n2));
        Color color = UNSELECTED_FOREGROUND;
        if (iNaviViewNode.isSelected()) {
            color = SELECTED_FOREGROUND;
        } else if (!iNaviViewNode.isVisible()) {
            color = INVISIBLE_FOREGROUND;
        }
        this.setForeground(color);
        if (n3 == 0) {
            this.setText(String.valueOf(iNaviViewNode.getIncomingEdges().size()));
        } else if (n3 == 1) {
            this.setText(String.valueOf(iNaviViewNode.getOutgoingEdges().size()));
        } else if (n3 == 2) {
            this.setText(CNodeChooserRenderer.getNodeText(iNaviViewNode));
        } else {
            this.setText("");
        }
        this.setBackground(DEFAULT_BACKGROUND);
        if (n3 == 3) {
            this.setBackground(iNaviViewNode.getColor());
        } else {
            this.calculateBackgroundColor(iNaviViewNode);
        }
        this.setToolTipText(CNodeChooserRenderer.buildToolTip(((NaviNode)this.m_graph.getNode(iNaviViewNode)).getNodeContent()));
        return this;
    }
}

