/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Loader;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Loader.CViewSettingsGenerator;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.BaseTypeTransferHandler;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyGraphBuilderManager;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.types.DragAndDropSupportWrapper;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.ZyGraphBuilder;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraphDragAndDropSupport;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraph2DView;
import java.util.HashMap;
import java.util.Map;
import y.i.U;

public final class CGraphBuilder {
    private CGraphBuilder() {
    }

    private static Pair<Map<String, String>, ZyGraphViewSettings> loadNativeSettings(INaviView iNaviView) {
        ConfigManager configManager = ConfigManager.instance();
        ZyGraphViewSettings zyGraphViewSettings = iNaviView.getGraphType() == GraphType.CALLGRAPH ? configManager.getDefaultCallGraphSettings() : configManager.getDefaultFlowGraphSettings();
        zyGraphViewSettings.getProximitySettings().setProximityBrowsing(iNaviView.getGraph().nodeCount() >= zyGraphViewSettings.getProximitySettings().getProximityBrowsingActivationThreshold());
        return new Pair<Map<String, String>, ZyGraphViewSettings>(new HashMap(), zyGraphViewSettings);
    }

    private static Pair<Map<String, String>, ZyGraphViewSettings> loadNonNativeSettings(INaviView iNaviView) {
        try {
            return CViewSettingsGenerator.createSettings(iNaviView);
        }
        catch (CouldntLoadDataException couldntLoadDataException) {
            ConfigManager configManager = ConfigManager.instance();
            ZyGraphViewSettings zyGraphViewSettings = iNaviView.getGraphType() == GraphType.CALLGRAPH ? configManager.getDefaultCallGraphSettings() : configManager.getDefaultFlowGraphSettings();
            return new Pair<Map<String, String>, ZyGraphViewSettings>(new HashMap(), zyGraphViewSettings);
        }
    }

    private static Pair<Map<String, String>, ZyGraphViewSettings> loadSettings(INaviView iNaviView) {
        return iNaviView.getType() == ViewType.Native ? CGraphBuilder.loadNativeSettings(iNaviView) : CGraphBuilder.loadNonNativeSettings(iNaviView);
    }

    public static ZyGraph buildDnDGraph(INaviView iNaviView, TypeManager typeManager) {
        ZyGraph zyGraph = CGraphBuilder.buildGraph(iNaviView);
        ZyGraphDragAndDropSupport zyGraphDragAndDropSupport = new ZyGraphDragAndDropSupport(zyGraph, new BaseTypeTransferHandler(typeManager, new DragAndDropSupportWrapper(zyGraph)));
        zyGraphDragAndDropSupport.enableDndSupport();
        return zyGraph;
    }

    public static ZyGraph buildGraph(INaviView iNaviView) {
        Preconditions.checkNotNull(iNaviView, "IE01763: View argument can't be null");
        Pair<Map<String, String>, ZyGraphViewSettings> pair = CGraphBuilder.loadSettings(iNaviView);
        Map<String, String> map = pair.first();
        ZyGraphViewSettings zyGraphViewSettings = pair.second();
        zyGraphViewSettings.rawSettings = map;
        ZyGraphBuilder zyGraphBuilder = new ZyGraphBuilder();
        ZyGraphBuilderManager.instance().setBuilder(iNaviView, zyGraphBuilder);
        U u2 = zyGraphBuilder.convert(iNaviView.getGraph().getNodes(), iNaviView.getGraph().getEdges(), zyGraphViewSettings, iNaviView.getType() == ViewType.Native);
        ZyGraph2DView zyGraph2DView = new ZyGraph2DView(u2);
        ZyGraph zyGraph = new ZyGraph(iNaviView, zyGraphBuilder.getNodeMap(), zyGraphBuilder.getEdgeMap(), zyGraphViewSettings, zyGraph2DView);
        zyGraph.getView().setCenter(CViewSettingsGenerator.createDoubleSetting(map, "view_center_x", 0.0), CViewSettingsGenerator.createDoubleSetting(map, "view_center_y", 0.0));
        zyGraph.getView().setWorldRect(CViewSettingsGenerator.createIntegerSetting(map, "world_rect_x", 0), CViewSettingsGenerator.createIntegerSetting(map, "world_rect_y", 0), CViewSettingsGenerator.createIntegerSetting(map, "world_rect_width", 800), CViewSettingsGenerator.createIntegerSetting(map, "world_rect_height", 600));
        zyGraph.getView().setZoom(CViewSettingsGenerator.createDoubleSetting(map, "zoom", 1.0));
        ZyGraphBuilderManager.instance().removeBuilder(iNaviView);
        return zyGraph;
    }
}

