/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.ErrorDialog.CNaviErrorDialog;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CGraphSettingsDialog;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CViewCommentDialog;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CodeNodeComments.DialogEditCodeNodeComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.GroupNodeComments.DialogEditGroupNodeComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.TextNodeComments.DialogTextNodeComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphLayouter;
import com.google.security.zynamics.binnavi.ZyGraph.LayoutStyle;
import com.google.security.zynamics.binnavi.disassembly.CGroupNode;
import com.google.security.zynamics.binnavi.disassembly.CTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.Window;
import javax.swing.JFrame;
import y.f.a.a;
import y.f.c.q;
import y.f.f.c;

public final class CGraphDialogs {
    private CGraphDialogs() {
    }

    public static void showGraphSettingsDialog(JFrame jFrame, ZyGraph zyGraph) {
        CGraphSettingsDialog cGraphSettingsDialog = new CGraphSettingsDialog(jFrame, "Graph Settings", zyGraph.getSettings(), false, false);
        cGraphSettingsDialog.setVisible(true);
        if (!cGraphSettingsDialog.wasCanceled()) {
            if (zyGraph.getSettings().getLayoutSettings().getCurrentLayouter() instanceof a) {
                zyGraph.getSettings().getLayoutSettings().setDefaultGraphLayout(LayoutStyle.CIRCULAR);
            } else if (zyGraph.getSettings().getLayoutSettings().getCurrentLayouter() instanceof q) {
                zyGraph.getSettings().getLayoutSettings().setDefaultGraphLayout(LayoutStyle.HIERARCHIC);
            } else if (zyGraph.getSettings().getLayoutSettings().getCurrentLayouter() instanceof c) {
                zyGraph.getSettings().getLayoutSettings().setDefaultGraphLayout(LayoutStyle.ORTHOGONAL);
            }
            if (cGraphSettingsDialog.needsLayouting()) {
                CGraphLayouter.refreshLayout(jFrame, zyGraph);
            }
        }
    }

    public static void showGroupNodeCommentDialog(JFrame jFrame, CGroupNode cGroupNode) {
        DialogEditGroupNodeComment dialogEditGroupNodeComment = new DialogEditGroupNodeComment(jFrame, cGroupNode);
        GuiHelper.centerChildToParent(jFrame, dialogEditGroupNodeComment, true);
        dialogEditGroupNodeComment.setVisible(true);
    }

    public static void showInstructionCommentDialog(JFrame jFrame, CGraphModel cGraphModel, INaviCodeNode iNaviCodeNode, INaviInstruction iNaviInstruction) {
        DialogEditCodeNodeComment dialogEditCodeNodeComment = new DialogEditCodeNodeComment(jFrame, cGraphModel, iNaviCodeNode, iNaviInstruction);
        GuiHelper.centerChildToParent(jFrame, dialogEditCodeNodeComment, true);
        dialogEditCodeNodeComment.setVisible(true);
    }

    public static void showTextNodeCommentDialog(JFrame jFrame, CTextNode cTextNode) {
        DialogTextNodeComment dialogTextNodeComment = new DialogTextNodeComment((Window)jFrame, cTextNode);
        GuiHelper.centerChildToParent(jFrame, dialogTextNodeComment, true);
        dialogTextNodeComment.setVisible(true);
    }

    public static void showViewDescriptionDialog(JFrame jFrame, INaviView iNaviView) {
        CViewCommentDialog cViewCommentDialog = new CViewCommentDialog((Window)jFrame, "Change view description", iNaviView.getName(), iNaviView.getConfiguration().getDescription());
        cViewCommentDialog.setVisible(true);
        if (!cViewCommentDialog.wasCancelled()) {
            try {
                iNaviView.getConfiguration().setName(cViewCommentDialog.getName());
                iNaviView.getConfiguration().setDescription(cViewCommentDialog.getComment());
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
                String string2 = "E00114: View description could not be changed";
                String string3 = CUtilityFunctions.createDescription(String.format("The view description of view '%s' could not be changed.", iNaviView.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view was not updated and the new view description is lost."});
                CNaviErrorDialog.show((Window)jFrame, (String)"E00114: View description could not be changed", (String)string3, (Throwable)exception);
            }
        }
    }
}

