/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CResumeHotkeyAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CShowHotkeysAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CStepBlockHotkeyAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CStepIntoHotkeyAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CStepOverHotkeyAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IFrontEndDebuggerProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Goto.CGotoAddressField;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Gui.CGraphSearchField;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import y.i.ar;

public final class CGraphHotkeys {
    private CGraphHotkeys() {
    }

    private static void registerDebuggerKeys(JFrame jFrame, ZyGraph zyGraph, IFrontEndDebuggerProvider iFrontEndDebuggerProvider, InputMap inputMap, ActionMap actionMap) {
        CStepIntoHotkeyAction cStepIntoHotkeyAction = new CStepIntoHotkeyAction(jFrame, iFrontEndDebuggerProvider);
        CStepOverHotkeyAction cStepOverHotkeyAction = new CStepOverHotkeyAction(jFrame, zyGraph, iFrontEndDebuggerProvider);
        CStepBlockHotkeyAction cStepBlockHotkeyAction = new CStepBlockHotkeyAction(jFrame, zyGraph, iFrontEndDebuggerProvider);
        CResumeHotkeyAction cResumeHotkeyAction = new CResumeHotkeyAction(jFrame, iFrontEndDebuggerProvider);
        inputMap.put(HotKeys.DEBUGGER_SINGLE_STEP_KEY.getKeyStroke(), "SINGLE_STEP");
        actionMap.put("SINGLE_STEP", cStepIntoHotkeyAction);
        inputMap.put(HotKeys.DEBUGGER_STEP_OVER_KEY.getKeyStroke(), "STEP_OVER");
        actionMap.put("STEP_OVER", cStepOverHotkeyAction);
        inputMap.put(HotKeys.DEBUGGER_STEP_BLOCK_KEY.getKeyStroke(), "STEP_BLOCK");
        actionMap.put("STEP_BLOCK", cStepBlockHotkeyAction);
        inputMap.put(HotKeys.DEBUGGER_RESUME_KEY.getKeyStroke(), "RESUME");
        actionMap.put("RESUME", cResumeHotkeyAction);
    }

    private static void registerSearchKeys(ar ar2, final CGraphSearchField cGraphSearchField, InputMap inputMap, ActionMap actionMap) {
        inputMap.put(HotKeys.GRAPH_SEARCHFIELD_FOCUS_KEY.getKeyStroke(), "FOCUS_SEARCHFIELD");
        ar2.getInputMap().put(HotKeys.GRAPH_SEARCH_NEXT_KEY.getKeyStroke(), "NEXT");
        inputMap.put(HotKeys.GRAPH_SEARCH_NEXT_ZOOM_KEY.getKeyStroke(), "NEXT_ZOOM");
        inputMap.put(HotKeys.GRAPH_SEARCH_PREVIOUS_KEY.getKeyStroke(), "PREVIOUS");
        inputMap.put(HotKeys.GRAPH_SEARCH_PREVIOUS_ZOOM_KEY.getKeyStroke(), "PREVIOUS_ZOOM");
        ar2.getActionMap().put("NEXT", new AbstractAction(){
            private static final long serialVersionUID = -7289167985570632361L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cGraphSearchField.centerNextSearchHit(false, false);
            }
        });
        actionMap.put("NEXT_ZOOM", new AbstractAction(){
            private static final long serialVersionUID = -74113347341296669L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cGraphSearchField.centerNextSearchHit(false, true);
            }
        });
        actionMap.put("PREVIOUS", new AbstractAction(){
            private static final long serialVersionUID = 5698412623106859554L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cGraphSearchField.centerNextSearchHit(true, false);
            }
        });
        actionMap.put("PREVIOUS_ZOOM", new AbstractAction(){
            private static final long serialVersionUID = -5246885767421937156L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cGraphSearchField.centerNextSearchHit(true, true);
            }
        });
        actionMap.put("FOCUS_SEARCHFIELD", new AbstractAction(){
            private static final long serialVersionUID = 7918948798657638098L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cGraphSearchField.requestFocusInWindow();
            }
        });
    }

    public static void registerHotKeys(JFrame jFrame, CGraphPanel cGraphPanel, IFrontEndDebuggerProvider iFrontEndDebuggerProvider, CGraphSearchField cGraphSearchField, final CGotoAddressField cGotoAddressField) {
        Preconditions.checkNotNull(jFrame, "IE01606: Parent argument can not be null");
        Preconditions.checkNotNull(cGraphPanel, "IE01607: Panel argument can not be null");
        Preconditions.checkNotNull(cGraphSearchField, "IE01608: Search field argument can not be null");
        Preconditions.checkNotNull(cGotoAddressField, "IE01609: Address field argument can not be null");
        InputMap inputMap = cGraphPanel.getInputMap(2);
        ActionMap actionMap = cGraphPanel.getActionMap();
        inputMap.put(HotKeys.GRAPH_GOTO_ADDRESS_FIELD_KEY.getKeyStroke(), "GOTO_ADDRESS_FIELD");
        actionMap.put("GOTO_ADDRESS_FIELD", new AbstractAction(){
            private static final long serialVersionUID = -8994014581850287793L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cGotoAddressField.requestFocusInWindow();
            }
        });
        inputMap.put(HotKeys.GRAPH_SHOW_HOTKEYS_ACCELERATOR_KEY.getKeyStroke(), "SHOW_HOTKEYS");
        actionMap.put("SHOW_HOTKEYS", new CShowHotkeysAction(jFrame));
        CGraphHotkeys.registerSearchKeys(cGraphPanel.getModel().getGraph().getView(), cGraphSearchField, inputMap, actionMap);
        CGraphHotkeys.registerDebuggerKeys(cGraphPanel.getModel().getParent(), cGraphPanel.getModel().getGraph(), iFrontEndDebuggerProvider, inputMap, actionMap);
    }
}

