/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.pathfinder;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.BasicBlock;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionListenerAdapter;
import com.google.security.zynamics.binnavi.API.helpers.IProgressThread;
import com.google.security.zynamics.binnavi.API.helpers.Logger;
import com.google.security.zynamics.binnavi.API.helpers.MessageBox;
import com.google.security.zynamics.binnavi.API.helpers.ProgressDialog;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.FunctionTreeBlockNode;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.FunctionTreeNode;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.IFunctionTreeNode;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.PathfinderPlugin;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

public final class FunctionTreeFunctionNode
extends FunctionTreeNode
implements IFunctionTreeNode {
    private static final ImageIcon ICON_FUNCTION_LOADED = new ImageIcon(PathfinderPlugin.class.getResource("resources/graph2.png"));
    private static final ImageIcon ICON_FUNCTION_CLOSED = new ImageIcon(PathfinderPlugin.class.getResource("resources/graph2_gray.png"));
    private final JDialog m_parent;
    private final Function m_function;
    private final InternalFunctionListener m_listener = new InternalFunctionListener();

    public FunctionTreeFunctionNode(JDialog parent, Function function) {
        this.m_function = Preconditions.checkNotNull(function);
        this.m_parent = Preconditions.checkNotNull(parent);
        this.createBlockNodes();
        function.addListener(this.m_listener);
        this.updateIcon();
    }

    private void createBlockNodes() {
        if (this.m_function.isLoaded()) {
            List<BasicBlock> blocks = this.m_function.getGraph().getNodes();
            for (BasicBlock block : blocks) {
                this.add(new FunctionTreeBlockNode(block));
            }
        }
    }

    private void updateIcon() {
        this.setIcon(this.m_function.isLoaded() ? ICON_FUNCTION_LOADED : ICON_FUNCTION_CLOSED);
    }

    public void dispose() {
        this.m_function.removeListener(this.m_listener);
    }

    @Override
    public void doubleClicked() {
        if (!this.m_function.isLoaded()) {
            ProgressDialog.show(this.m_parent, "Loading Function", new IProgressThread(){

                @Override
                public boolean close() {
                    return false;
                }

                @Override
                public void run() {
                    try {
                        FunctionTreeFunctionNode.this.m_function.load();
                    }
                    catch (CouldntLoadDataException e2) {
                        Logger.logException(e2);
                        MessageBox.showException(FunctionTreeFunctionNode.this.m_parent, e2, "Function could not be loaded.");
                    }
                }
            });
        }
    }

    public Function getFunction() {
        return this.m_function;
    }

    @Override
    public boolean isVisible() {
        return this.getFilter() == null || this.getFilter().matchesFilter(this.m_function.getName());
    }

    @Override
    public String toString() {
        return this.m_function.getName();
    }

    private class InternalFunctionListener
    extends FunctionListenerAdapter {
        private InternalFunctionListener() {
        }

        @Override
        public void loadedFunction(Function function) {
            FunctionTreeFunctionNode.this.updateIcon();
            FunctionTreeFunctionNode.this.createBlockNodes();
        }
    }
}

