/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.criterium;

import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.API.helpers.GraphAlgorithms;
import com.google.security.zynamics.binnavi.API.plugins.ICriteriaSelectionPlugin;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.yfileswrap.API.disassembly.View2D;
import javax.swing.JPanel;

public class LoopSelectionCriteriumPlugin
implements IPlugin<IPluginInterface>,
ICriteriaSelectionPlugin {
    @Override
    public ICriteriaSelectionPlugin.ICriterium getCriterium(View2D view2D) {
        return new LoopCriterium();
    }

    @Override
    public String getCriteriumDescription() {
        return "Select Nodes in loops";
    }

    @Override
    public String getDescription() {
        return "Extends the Select by Criteria dialog to offer the option to select all nodes that are inside loops.";
    }

    @Override
    public long getGuid() {
        return 423749054235790534L;
    }

    @Override
    public String getName() {
        return "Loop Selection Plugin";
    }

    @Override
    public void init(IPluginInterface pluginInterface) {
    }

    @Override
    public void unload() {
    }

    private static class LoopCriterium
    implements ICriteriaSelectionPlugin.ICriterium {
        private final JPanel m_panel = new JPanel();

        private LoopCriterium() {
        }

        @Override
        public String getCriteriumDescription() {
            return "Select Nodes in loops";
        }

        @Override
        public JPanel getCriteriumPanel() {
            return this.m_panel;
        }

        @Override
        public ICriteriaSelectionPlugin.IFixedCriterium getFixedCriterium() {
            return new EmptyFixedCriterium();
        }

        @Override
        public String getFormulaString() {
            return "in loop";
        }

        @Override
        public boolean matches(ViewNode node) {
            return GraphAlgorithms.getSuccessors(node).contains(node);
        }
    }

    private static class EmptyFixedCriterium
    implements ICriteriaSelectionPlugin.IFixedCriterium {
        private EmptyFixedCriterium() {
        }

        @Override
        public boolean matches(ViewNode node) {
            return GraphAlgorithms.getSuccessors(node).contains(node);
        }
    }
}

