/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.coverage;

import com.google.security.zynamics.binnavi.API.gui.GraphFrame;
import com.google.security.zynamics.binnavi.API.plugins.IGraphMenuPlugin;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.standardplugins.coverage.VisualCoverageAction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public final class VisualCoveragePlugin
implements IGraphMenuPlugin {
    private final List<VisualCoverageAction> createdActions = new ArrayList<VisualCoverageAction>();

    @Override
    public void closed(GraphFrame graphFrame) {
        for (VisualCoverageAction action : this.createdActions) {
            if (action.getFrame() != graphFrame) continue;
            action.dispose();
            this.createdActions.remove(action);
            return;
        }
    }

    @Override
    public List<JComponent> extendPluginMenu(GraphFrame graphFrame) {
        ArrayList<JComponent> additionalMenus = new ArrayList<JComponent>();
        VisualCoverageAction action = new VisualCoverageAction(graphFrame);
        this.createdActions.add(action);
        additionalMenus.add(new JMenuItem(action));
        return additionalMenus;
    }

    @Override
    public String getDescription() {
        return "This plugin can be used to create simple code coverage traces.";
    }

    @Override
    public long getGuid() {
        return 54235790543L;
    }

    @Override
    public String getName() {
        return "Visual Coverage";
    }

    @Override
    public void init(IPluginInterface pluginInterface) {
    }

    @Override
    public void unload() {
        for (VisualCoverageAction action : this.createdActions) {
            action.dispose();
        }
        this.createdActions.clear();
    }
}

