/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.coverage;

import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.gui.GraphFrame;
import com.google.security.zynamics.binnavi.API.helpers.MessageBox;
import com.google.security.zynamics.binnavi.standardplugins.coverage.IVisualCoverageListener;
import com.google.security.zynamics.binnavi.standardplugins.coverage.VisualCoverage;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public final class VisualCoverageAction
extends AbstractAction {
    private GraphFrame graphFrame;
    private VisualCoverage coverage = null;
    private final IVisualCoverageListener traceListener = new InternalTraceListener();

    public VisualCoverageAction(GraphFrame graphFrame) {
        super("Visual Coverage");
        this.graphFrame = graphFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        JFrame parent = null;
        if (this.coverage != null) {
            MessageBox.showInformation(parent, "Visual Coverage trace is already active");
            return;
        }
        List<Debugger> debuggers = this.graphFrame.getDebuggers();
        if (debuggers.size() == 0) {
            MessageBox.showInformation(parent, "Visual Coverage trace can not be started because no debugger is configured for this graph.");
            return;
        }
        if (debuggers.size() != 1) {
            MessageBox.showInformation(parent, "Visual Coverage trace can not be started because more than one debugger is configured for this graph.");
            return;
        }
        Debugger debugger = debuggers.get(0);
        this.coverage = new VisualCoverage(parent, debugger, this.graphFrame.getView2D());
        this.coverage.addListener(this.traceListener);
    }

    public void dispose() {
        if (this.coverage != null) {
            this.coverage.removeListener(this.traceListener);
            this.coverage.dispose();
            this.coverage = null;
            this.graphFrame = null;
        }
    }

    public GraphFrame getFrame() {
        return this.graphFrame;
    }

    private class InternalTraceListener
    implements IVisualCoverageListener {
        private InternalTraceListener() {
        }

        @Override
        public void finishedCoverage() {
            VisualCoverageAction.this.coverage.removeListener(VisualCoverageAction.this.traceListener);
            VisualCoverageAction.this.coverage = null;
        }
    }
}

