/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.coverage;

import com.google.security.zynamics.binnavi.API.debug.BreakpointManager;
import com.google.security.zynamics.binnavi.API.debug.DebugException;
import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.debug.IProcessListener;
import com.google.security.zynamics.binnavi.API.debug.IThreadListener;
import com.google.security.zynamics.binnavi.API.debug.Process;
import com.google.security.zynamics.binnavi.API.debug.ProcessListenerAdapter;
import com.google.security.zynamics.binnavi.API.debug.Thread;
import com.google.security.zynamics.binnavi.API.debug.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CodeNode;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionNode;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.API.helpers.IProgressThread;
import com.google.security.zynamics.binnavi.API.helpers.MessageBox;
import com.google.security.zynamics.binnavi.API.helpers.ProgressDialog;
import com.google.security.zynamics.binnavi.standardplugins.coverage.IVisualCoverageListener;
import com.google.security.zynamics.binnavi.yfileswrap.API.disassembly.View2D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;

public final class VisualCoverage {
    private static final Color COLOR_FEW_HITS = new Color(186, 255, 170);
    private static final Color COLOR_SEVERAL_HITS = new Color(147, 213, 255);
    private static final Color COLOR_MANY_HITS = new Color(255, 168, 191);
    private static final Color COLOR_CURRENT_HIT = Color.YELLOW;
    private final JFrame parent;
    private final Debugger debugger;
    private final View2D view2d;
    private final IProcessListener processListener = new InternalProcessListener();
    private final IThreadListener threadListener = new InternalThreadListener();
    private final List<Address> myBreakpoints = new ArrayList<Address>();
    private final Map<Address, Integer> breakpointCounter = new HashMap<Address, Integer>();
    private final Map<Address, ViewNode> nodeMap = new HashMap<Address, ViewNode>();
    private Address previousNodeAddress = null;
    private final List<IVisualCoverageListener> listeners = new ArrayList<IVisualCoverageListener>();

    public VisualCoverage(JFrame parent, Debugger debugger, View2D view2d) {
        this.parent = parent;
        this.debugger = debugger;
        this.view2d = view2d;
        ProgressDialog.show(parent, "Initializing graph and breakpoints ...", new StartupThread());
        debugger.getProcess().addListener(this.processListener);
        if (debugger.isConnected()) {
            this.setupListeners();
        }
    }

    private void finish() {
        this.updatePreviousNode();
        for (IVisualCoverageListener listener : new ArrayList<IVisualCoverageListener>(this.listeners)) {
            listener.finishedCoverage();
        }
    }

    private Address getAddress(ViewNode node) {
        if (node instanceof CodeNode) {
            return ((CodeNode)node).getAddress();
        }
        if (node instanceof FunctionNode) {
            return ((FunctionNode)node).getFunction().getAddress();
        }
        throw new IllegalStateException("Error: Invalid node passed to getAddress");
    }

    private void removeListeners() {
        Process process = this.debugger.getProcess();
        process.removeListener(this.processListener);
        for (Thread thread2 : process.getThreads()) {
            thread2.removeListener(this.threadListener);
        }
    }

    private void removeRemainingBreakpoints() {
        ProgressDialog.show(this.parent, "Removing remaining breakpoints ...", new CleanupThread());
    }

    private void setBreakpoint(Address address) {
        BreakpointManager breakpointManager = this.debugger.getBreakpointManager();
        if (!breakpointManager.hasBreakpoint(null, address)) {
            breakpointManager.setBreakpoint(null, address);
        }
    }

    private void setupListeners() {
        Process process = this.debugger.getProcess();
        for (Thread thread2 : process.getThreads()) {
            thread2.addListener(this.threadListener);
        }
    }

    private void updatePreviousNode() {
        if (this.previousNodeAddress == null || !this.myBreakpoints.contains(this.previousNodeAddress)) {
            return;
        }
        ViewNode node = this.nodeMap.get(this.previousNodeAddress);
        int count = this.breakpointCounter.get(this.previousNodeAddress);
        if (count < 5) {
            node.setColor(COLOR_FEW_HITS);
        } else if (count < 10) {
            node.setColor(COLOR_SEVERAL_HITS);
        } else {
            node.setColor(COLOR_MANY_HITS);
            BreakpointManager breakpointManager = this.debugger.getBreakpointManager();
            if (breakpointManager.hasBreakpoint(null, this.previousNodeAddress)) {
                breakpointManager.removeBreakpoint(null, this.previousNodeAddress);
                this.myBreakpoints.remove(this.previousNodeAddress);
            }
        }
        try {
            java.lang.Thread.sleep(100L);
        }
        catch (InterruptedException e2) {
            java.lang.Thread.currentThread().interrupt();
        }
    }

    public void addListener(IVisualCoverageListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.updatePreviousNode();
        this.removeRemainingBreakpoints();
        this.removeListeners();
    }

    public void removeListener(IVisualCoverageListener listener) {
        this.listeners.remove(listener);
    }

    private class StartupThread
    implements IProgressThread {
        private StartupThread() {
        }

        @Override
        public boolean close() {
            return false;
        }

        @Override
        public void run() {
            for (ViewNode node : VisualCoverage.this.view2d.getView().getGraph()) {
                if (!(node instanceof CodeNode) && !(node instanceof FunctionNode)) continue;
                node.setColor(Color.WHITE);
                Address address = VisualCoverage.this.getAddress(node);
                VisualCoverage.this.setBreakpoint(address);
                VisualCoverage.this.myBreakpoints.add(address);
                VisualCoverage.this.breakpointCounter.put(address, 0);
                VisualCoverage.this.nodeMap.put(address, node);
            }
        }
    }

    private class InternalThreadListener
    extends ThreadListenerAdapter {
        private InternalThreadListener() {
        }

        @Override
        public void changedProgramCounter(Thread thread2) {
            Address currentAddress = thread2.getCurrentAddress();
            if (VisualCoverage.this.myBreakpoints.contains(currentAddress)) {
                VisualCoverage.this.breakpointCounter.put(currentAddress, (Integer)VisualCoverage.this.breakpointCounter.get(currentAddress) + 1);
                ViewNode currentNode = (ViewNode)VisualCoverage.this.nodeMap.get(currentAddress);
                currentNode.setColor(COLOR_CURRENT_HIT);
                VisualCoverage.this.updatePreviousNode();
                VisualCoverage.this.previousNodeAddress = currentAddress;
                if (VisualCoverage.this.myBreakpoints.isEmpty()) {
                    VisualCoverage.this.removeListeners();
                    VisualCoverage.this.finish();
                }
                try {
                    VisualCoverage.this.debugger.resume();
                }
                catch (DebugException exception) {
                    MessageBox.showError(VisualCoverage.this.parent, "Could not resume the target process");
                }
            } else if (VisualCoverage.this.debugger.getBreakpointManager().hasBreakpoint(null, currentAddress)) {
                // empty if block
            }
        }
    }

    private class InternalProcessListener
    extends ProcessListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void addedThread(Process process, Thread thread2) {
            thread2.addListener(VisualCoverage.this.threadListener);
        }

        @Override
        public void attached(Process process) {
            VisualCoverage.this.setupListeners();
        }

        @Override
        public void detached(Process process) {
            VisualCoverage.this.removeRemainingBreakpoints();
            VisualCoverage.this.removeListeners();
            VisualCoverage.this.finish();
        }

        @Override
        public void removedThread(Process process, Thread thread2) {
            thread2.removeListener(VisualCoverage.this.threadListener);
        }
    }

    private class CleanupThread
    implements IProgressThread {
        private CleanupThread() {
        }

        @Override
        public boolean close() {
            return false;
        }

        @Override
        public void run() {
            BreakpointManager breakpointManager = VisualCoverage.this.debugger.getBreakpointManager();
            for (Address address : VisualCoverage.this.myBreakpoints) {
                if (!breakpointManager.hasBreakpoint(null, address)) continue;
                breakpointManager.removeBreakpoint(null, address);
            }
        }
    }
}

