/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.callresolver;

import com.google.security.zynamics.binnavi.API.debug.MemoryModule;
import com.google.security.zynamics.binnavi.API.disassembly.Callgraph;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.EdgeType;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionEdge;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionNode;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewEdge;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ICallResolverTarget;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.IndirectCall;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.IndirectCallResolver;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ResolvedFunction;
import java.awt.Color;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OutputGraphGenerator {
    public static View createCompleteView(ICallResolverTarget target, List<IndirectCall> indirectCallAddresses, Map<BigInteger, Set<ResolvedFunction>> resolvedAddresses) {
        FunctionNode sourceNode;
        View view = target.createView();
        HashMap<Function, FunctionNode> nodes = new HashMap<Function, FunctionNode>();
        for (Module module : target.getModules()) {
            for (Function function : module.getFunctions()) {
                FunctionNode node = view.createFunctionNode(function);
                nodes.put(function, node);
            }
            Callgraph callgraph = module.getCallgraph();
            for (FunctionEdge edge : callgraph.getEdges()) {
                sourceNode = (FunctionNode)nodes.get(edge.getSource().getFunction());
                FunctionNode targetNode = (FunctionNode)nodes.get(edge.getTarget().getFunction());
                view.createEdge(sourceNode, targetNode, EdgeType.JumpUnconditional);
            }
        }
        for (Map.Entry entry : resolvedAddresses.entrySet()) {
            BigInteger start = (BigInteger)entry.getKey();
            Set set = (Set)entry.getValue();
            IndirectCall call = IndirectCallResolver.findIndirectCall(target.getDebugger(), indirectCallAddresses, start);
            sourceNode = (FunctionNode)nodes.get(call.getFunction());
            if (sourceNode == null) continue;
            for (ResolvedFunction targetFunction : set) {
                Function function = targetFunction.getFunction();
                if (function == null) continue;
                FunctionNode targetNode = (FunctionNode)nodes.get(function);
                ViewEdge edge = view.createEdge(sourceNode, targetNode, EdgeType.JumpUnconditional);
                edge.setColor(Color.RED);
            }
        }
        return view;
    }

    public static View createLoggedView(ICallResolverTarget target, List<IndirectCall> indirectCallAddresses, Map<BigInteger, Set<ResolvedFunction>> resolvedAddresses) {
        View view = target.createView();
        HashMap<Function, FunctionNode> nodes = new HashMap<Function, FunctionNode>();
        for (Map.Entry<BigInteger, Set<ResolvedFunction>> element : resolvedAddresses.entrySet()) {
            BigInteger start = element.getKey();
            Set<ResolvedFunction> targets = element.getValue();
            IndirectCall call = IndirectCallResolver.findIndirectCall(target.getDebugger(), indirectCallAddresses, start);
            FunctionNode sourceNode = (FunctionNode)nodes.get(call.getFunction());
            if (sourceNode == null) {
                sourceNode = view.createFunctionNode(call.getFunction());
                nodes.put(call.getFunction(), sourceNode);
            }
            for (ResolvedFunction targetFunction : targets) {
                String e22;
                String targetString;
                Function function = targetFunction.getFunction();
                MemoryModule memoryModule = targetFunction.getMemoryModule();
                if (function != null) {
                    FunctionNode targetNode = (FunctionNode)nodes.get(function);
                    if (targetNode == null) {
                        targetNode = view.createFunctionNode(function);
                        nodes.put(function, targetNode);
                    }
                    try {
                        String string2 = String.valueOf(start.toString(16).toUpperCase());
                        String string3 = String.valueOf(function.getAddress().toHexString().toUpperCase());
                        sourceNode.appendComment(new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" -> ").append(string3).toString());
                    }
                    catch (CouldntLoadDataException | CouldntSaveDataException e3) {
                        e3.printStackTrace();
                    }
                    view.createEdge(sourceNode, targetNode, EdgeType.JumpUnconditional);
                    continue;
                }
                if (memoryModule != null) {
                    targetString = String.format("%s!%s", targetFunction.getMemoryModule().getName(), targetFunction.getAddress().toHexString().toUpperCase());
                    try {
                        e22 = String.valueOf(start.toString(16).toUpperCase());
                        sourceNode.appendComment(new StringBuilder(4 + String.valueOf(e22).length() + String.valueOf(targetString).length()).append(e22).append(" -> ").append(targetString).toString());
                    }
                    catch (CouldntLoadDataException | CouldntSaveDataException e22) {
                        e22.printStackTrace();
                    }
                    continue;
                }
                String string4 = String.valueOf(targetFunction.getAddress().toHexString().toUpperCase());
                targetString = string4.length() != 0 ? "???!".concat(string4) : new String("???!");
                try {
                    e22 = String.valueOf(start.toString(16).toUpperCase());
                    sourceNode.appendComment(new StringBuilder(4 + String.valueOf(e22).length() + String.valueOf(targetString).length()).append(e22).append(" -> ").append(targetString).toString());
                }
                catch (CouldntLoadDataException | CouldntSaveDataException e4) {
                    e4.printStackTrace();
                }
            }
        }
        for (Module module : target.getModules()) {
            Callgraph callgraph = module.getCallgraph();
            for (FunctionEdge edge : callgraph.getEdges()) {
                FunctionNode source = (FunctionNode)nodes.get(edge.getSource().getFunction());
                FunctionNode targetNode = (FunctionNode)nodes.get(edge.getTarget().getFunction());
                if (source == null || targetNode == null) continue;
                view.createEdge(source, targetNode, EdgeType.JumpUnconditional);
            }
        }
        return view;
    }
}

