/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.callresolver;

import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.ModuleListenerAdapter;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ICallResolverTarget;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ICallResolverTargetListener;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.IndirectCall;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.IndirectCallFinder;
import java.util.ArrayList;
import java.util.List;

public final class ModuleCallResolverTarget
implements ICallResolverTarget {
    private final Module module;
    private final List<ICallResolverTargetListener> listeners = new ArrayList<ICallResolverTargetListener>();
    private final InternalModuleListener internalModuleListener = new InternalModuleListener();

    public ModuleCallResolverTarget(Module module) {
        this.module = module;
        module.addListener(this.internalModuleListener);
    }

    @Override
    public void addListener(ICallResolverTargetListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public View createView() {
        return this.module.createView("Dynamic Trace View", "");
    }

    @Override
    public Debugger getDebugger() {
        return this.module.getDebugger();
    }

    @Override
    public List<IndirectCall> getIndirectCalls() {
        return IndirectCallFinder.find(this.module);
    }

    @Override
    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(this.module);
        return modules;
    }

    @Override
    public void removeListener(ICallResolverTargetListener listener) {
        this.listeners.remove(listener);
    }

    private class InternalModuleListener
    extends ModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void changedDebugger(Module module, Debugger debugger) {
            for (ICallResolverTargetListener listener : ModuleCallResolverTarget.this.listeners) {
                try {
                    listener.changedDebugger(ModuleCallResolverTarget.this, debugger);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

