/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.callresolver;

import com.google.security.zynamics.binnavi.API.debug.DebugException;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.helpers.Settings;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.CallResolver;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ICallResolverTarget;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.IndirectCall;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.OutputGraphGenerator;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.OutputListGenerator;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ResolvedFunction;
import com.google.security.zynamics.binnavi.yfileswrap.API.disassembly.View2D;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public final class CallResolverDialog
extends JDialog {
    private final IconPanel[] panels = new IconPanel[]{new IconPanel("1. Loading target"), new IconPanel("2. Find indirect calls"), new IconPanel("3. Start debugger", new ResumeButton()), new IconPanel("4. Set breakpoints"), new IconPanel("5. Resolving breakpoints"), new IconPanel("6. Stop call resolving")};
    private final JTextArea outputArea = new JTextArea();
    private final JButton listResolvedFunctionsButton = new JButton(new ListResolvedFunctionsAction());
    private final JButton graphResolvedFunctionsButton = new JButton(new GraphResolvedFunctionsAction());
    private final JButton portResultsButton = new JButton(new GraphAllFunctionsAction());
    private final NextAction nextAction = new NextAction();
    private final CallResolver callResolver;

    private CallResolverDialog(JFrame parent, ICallResolverTarget target) {
        super((Frame)parent, "Call Resolver");
        assert (parent != null);
        assert (target != null);
        this.callResolver = new InternalCallResolver(target, parent);
        this.setLayout(new BorderLayout());
        this.add((Component)new LabelPanel(), "North");
        this.add(new OutputPanel());
        this.add((Component)new ButtonPanel(), "South");
        this.setSize(700, 600);
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        Settings.setShowDialogs(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e2) {
                CallResolverDialog.this.close();
            }

            @Override
            public void windowClosing(WindowEvent e2) {
                CallResolverDialog.this.setVisible(false);
                CallResolverDialog.this.dispose();
            }
        });
        this.updateGui();
    }

    public static void show(JFrame parent, ICallResolverTarget target) {
        CallResolverDialog dialog = new CallResolverDialog(parent, target);
        dialog.setVisible(true);
    }

    private void appendOutput(String string2) {
        String string3 = String.valueOf(this.outputArea.getText());
        this.outputArea.setText(new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(string2).append("\n").toString());
        this.outputArea.setCaretPosition(this.outputArea.getDocument().getLength());
    }

    private void close() {
        Settings.setShowDialogs(true);
        this.callResolver.dispose();
        this.setVisible(false);
    }

    private void graphAllFunctions() {
        new Thread(){

            @Override
            public void run() {
                View view = OutputGraphGenerator.createCompleteView(CallResolverDialog.this.callResolver.getTarget(), CallResolverDialog.this.callResolver.getIndirectAddresses(), CallResolverDialog.this.callResolver.getResolvedAddresses());
                View2D view2d = PluginInterface.instance().showInLastWindow(view);
                view2d.doHierarchicalLayout();
                try {
                    view.save();
                }
                catch (CouldntSaveDataException e2) {
                    e2.printStackTrace();
                }
            }
        }.start();
    }

    private void graphResolvedFunctions() {
        new Thread(){

            @Override
            public void run() {
                View view = OutputGraphGenerator.createLoggedView(CallResolverDialog.this.callResolver.getTarget(), CallResolverDialog.this.callResolver.getIndirectAddresses(), CallResolverDialog.this.callResolver.getResolvedAddresses());
                View2D view2d = PluginInterface.instance().showInLastWindow(view);
                view2d.doHierarchicalLayout();
                try {
                    view.save();
                }
                catch (CouldntSaveDataException e2) {
                    e2.printStackTrace();
                }
            }
        }.start();
    }

    private void listResolvedFunctions() {
        this.outputArea.setText(OutputListGenerator.generate(this.callResolver.getResolvedAddresses()));
        this.outputArea.setCaretPosition(0);
    }

    private void updateGui() {
        int currentStep = this.callResolver.getCurrentStep();
        for (int i2 = 0; i2 < this.panels.length; ++i2) {
            this.panels[i2].setEnabled(i2 <= currentStep);
            this.panels[i2].setDone(i2 < currentStep);
        }
        this.listResolvedFunctionsButton.setEnabled(currentStep == this.panels.length);
        this.graphResolvedFunctionsButton.setEnabled(currentStep == this.panels.length);
        this.portResultsButton.setEnabled(currentStep == this.panels.length);
        this.nextAction.putValue("Name", currentStep == this.panels.length ? "Reset" : "Next");
    }

    private class ResumeButton
    extends JButton {
        public ResumeButton() {
            super(new ResumeAction());
            this.setPreferredSize(new Dimension(100, 20));
        }
    }

    private class ResumeAction
    extends AbstractAction {
        public ResumeAction() {
            super("Resume");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                CallResolverDialog.this.callResolver.getTarget().getDebugger().resume();
            }
            catch (DebugException exception) {
                CallResolverDialog.this.appendOutput(String.format("Error: Could not resume the debugger (%s)", exception.toString()));
            }
        }
    }

    private class OutputPanel
    extends JPanel {
        public OutputPanel() {
            super(new BorderLayout());
            CallResolverDialog.this.outputArea.setEditable(false);
            CallResolverDialog.this.outputArea.setFont(GuiHelper.MONOSPACED_FONT);
            this.add(new JScrollPane(CallResolverDialog.this.outputArea));
        }
    }

    private class NextAction
    extends AbstractAction {
        public NextAction() {
            super("Next");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CallResolverDialog.this.callResolver.next();
            CallResolverDialog.this.updateGui();
        }
    }

    private class ListResolvedFunctionsAction
    extends AbstractAction {
        public ListResolvedFunctionsAction() {
            super("Show resolved functions");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            CallResolverDialog.this.listResolvedFunctions();
        }
    }

    private class LabelPanel
    extends JPanel {
        public LabelPanel() {
            super(new GridLayout(CallResolverDialog.this.panels.length + 1, 1));
            for (IconPanel panel : CallResolverDialog.this.panels) {
                this.add(panel);
            }
            JPanel resultsPanel = new JPanel();
            resultsPanel.add(CallResolverDialog.this.listResolvedFunctionsButton);
            resultsPanel.add(CallResolverDialog.this.graphResolvedFunctionsButton);
            resultsPanel.add(CallResolverDialog.this.portResultsButton);
            this.add(resultsPanel);
            this.setBorder(new TitledBorder(""));
        }
    }

    private class InternalCallResolver
    extends CallResolver {
        public InternalCallResolver(ICallResolverTarget target, JFrame parent) {
            super(target, parent);
        }

        @Override
        protected void debuggerChanged() {
            CallResolverDialog.this.appendOutput("Error: Target debugger changed. Resetting.");
            CallResolverDialog.this.updateGui();
        }

        @Override
        protected void debuggerClosed() {
            CallResolverDialog.this.appendOutput("Target debugger was closed.");
            CallResolverDialog.this.updateGui();
        }

        @Override
        protected void errorConnectingDebugger(DebugException e2) {
            CallResolverDialog.this.appendOutput("Error: Could not start the debugger.");
        }

        @Override
        protected void errorLoadingModule(Module module, CouldntLoadDataException e2) {
            CallResolverDialog.this.appendOutput(String.format("Error loading module '%s' (%s)", module.getName(), e2.getMessage()));
        }

        @Override
        protected void errorNoDebugger() {
            CallResolverDialog.this.appendOutput("Error: No debugger configured for the selected target.");
        }

        @Override
        protected void errorNotAttached() {
            CallResolverDialog.this.appendOutput("Error: The debugger is not attached to the target process.");
        }

        @Override
        protected void errorResuming(DebugException e2) {
            CallResolverDialog.this.appendOutput("Error: Debugger could not be resumed after a breakpoint was hit.");
        }

        @Override
        protected void foundIndirectCallAddresses(List<IndirectCall> indirectCallAddresses) {
            CallResolverDialog.this.appendOutput(String.format("Found %d indirect calls", indirectCallAddresses.size()));
            if (indirectCallAddresses.isEmpty()) {
                CallResolverDialog.this.appendOutput("No indirect function calls found: The resolving process is complete");
            }
        }

        @Override
        protected void resolvedCall(BigInteger lastIndirectCall, ResolvedFunction resolvedFunction) {
            String string2;
            Address functionAddress;
            Function function = resolvedFunction.getFunction();
            Address address = functionAddress = function == null ? resolvedFunction.getAddress() : function.getAddress();
            if (function == null) {
                string2 = String.valueOf(resolvedFunction.getMemoryModule().getName()).concat("!???");
            } else {
                String string3 = function.getModule().getName();
                String string4 = function.getName();
                string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append("!").append(string4).toString();
            }
            String functionName = string2;
            CallResolverDialog.this.appendOutput(String.format("Done resolving: %08X -> %08X (%s)", lastIndirectCall.longValue(), functionAddress.toLong(), functionName));
        }
    }

    private static class IconPanel
    extends JPanel {
        private final JLabel textLabel;
        private JComponent additionalComponent;
        private static ImageIcon ACCEPT_IMAGE;
        private static ImageIcon BULLET_IMAGE;

        public IconPanel(String text2) {
            this(text2, null);
        }

        public IconPanel(String text2, JComponent additionalComponent) {
            super(new BorderLayout());
            if (ACCEPT_IMAGE == null) {
                try {
                    ACCEPT_IMAGE = new ImageIcon(CallResolverDialog.class.getResource("accept.png").toURI().toURL());
                    BULLET_IMAGE = new ImageIcon(CallResolverDialog.class.getResource("bullet_blue.png").toURI().toURL());
                }
                catch (MalformedURLException | URISyntaxException e2) {
                    e2.printStackTrace();
                }
            }
            this.textLabel = new JLabel(text2);
            this.textLabel.setEnabled(false);
            this.add(this.textLabel);
            if (additionalComponent != null) {
                this.additionalComponent = additionalComponent;
                this.add((Component)additionalComponent, "East");
            }
            this.setPreferredSize(new Dimension(200, 20));
        }

        public void setDone(boolean done) {
            this.textLabel.setIcon(done ? ACCEPT_IMAGE : BULLET_IMAGE);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.additionalComponent != null) {
                this.additionalComponent.setEnabled(enabled);
            }
            this.textLabel.setEnabled(enabled);
        }
    }

    private class GraphResolvedFunctionsAction
    extends AbstractAction {
        public GraphResolvedFunctionsAction() {
            super("Create limited call graph view");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            CallResolverDialog.this.graphResolvedFunctions();
        }
    }

    private class GraphAllFunctionsAction
    extends AbstractAction {
        public GraphAllFunctionsAction() {
            super("Create complete call graph view");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            CallResolverDialog.this.graphAllFunctions();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            CallResolverDialog.this.close();
        }
    }

    private class ButtonPanel
    extends JPanel {
        public ButtonPanel() {
            super(new BorderLayout());
            JPanel innerButtonPanel = new JPanel(new BorderLayout());
            innerButtonPanel.add((Component)new JButton(CallResolverDialog.this.nextAction), "West");
            innerButtonPanel.add((Component)new JButton(new CancelAction()), "East");
            this.add((Component)innerButtonPanel, "East");
        }
    }
}

