/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.models.Bookmarks.memory;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.IBookmarkListener;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class CBookmark {
    private final IAddress m_address;
    private String m_description;
    private final ListenerProvider<IBookmarkListener> m_listeners = new ListenerProvider();

    public CBookmark(IAddress address, String description) {
        this.m_address = Preconditions.checkNotNull(address, "IE00333: Bookmark addresses can't be null");
        this.m_description = Preconditions.checkNotNull(description, "IE00334: Bookmark descriptions can't be null");
    }

    public void addListener(IBookmarkListener listener) {
        this.m_listeners.addListener(listener);
    }

    public IAddress getAddress() {
        return this.m_address;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void removeListener(IBookmarkListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setDescription(String description) {
        Preconditions.checkNotNull(description, "IE00335: Bookmark description can't be null");
        if (this.m_description.equals(description)) {
            return;
        }
        this.m_description = description;
        for (IBookmarkListener listener : this.m_listeners) {
            try {
                listener.changedDescription(this, description);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

