/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.models.Bookmarks.memory;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.CBookmark;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.IBookmarkManagerListener;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BookmarkManager
implements Iterable<CBookmark> {
    private final List<CBookmark> m_bookmarks = new ArrayList<CBookmark>();
    private final ListenerProvider<IBookmarkManagerListener> m_listeners = new ListenerProvider();

    public void addBookmark(CBookmark bookmark) {
        Preconditions.checkNotNull(bookmark, "IE00382: Bookmark can not be null");
        Preconditions.checkArgument(this.getBookmark(bookmark.getAddress()) == null, "IE00383: Bookmark already exists at offset %s", bookmark.getAddress().toHexString());
        this.m_bookmarks.add(bookmark);
        for (IBookmarkManagerListener listener : this.m_listeners) {
            try {
                listener.addedBookmark(this, bookmark);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void addListener(IBookmarkManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public CBookmark getBookmark(IAddress address) {
        Preconditions.checkNotNull(address, "IE00384: Bookmark address can not be null");
        for (CBookmark bookmark : this.m_bookmarks) {
            if (!bookmark.getAddress().equals(address)) continue;
            return bookmark;
        }
        return null;
    }

    public CBookmark getBookmark(int index) {
        return this.m_bookmarks.get(index);
    }

    public int getNumberOfBookmarks() {
        return this.m_bookmarks.size();
    }

    @Override
    public Iterator<CBookmark> iterator() {
        return this.m_bookmarks.iterator();
    }

    public void removeBookmark(CBookmark bookmark) {
        Preconditions.checkNotNull(bookmark, "IE00385: Bookmark can not be null");
        Preconditions.checkArgument(this.m_bookmarks.remove(bookmark), "IE00386: Bookmark is not managed by this manager");
        for (IBookmarkManagerListener listener : this.m_listeners) {
            try {
                listener.removedBookmark(this, bookmark);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void removeListener(IBookmarkManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }
}

