/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.models.Bookmarks.code;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.models.Bookmarks.code.ICodeBookmarkListener;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class CCodeBookmark {
    private final INaviModule m_module;
    private final IAddress m_address;
    private String m_description;
    private final ListenerProvider<ICodeBookmarkListener> m_listeners = new ListenerProvider();

    public CCodeBookmark(INaviModule module, IAddress address, String description) {
        this.m_module = Preconditions.checkNotNull(module, "IE00324: Module argument can not be null");
        this.m_address = Preconditions.checkNotNull(address, "IE00325: Address argument can not be null");
        this.m_description = Preconditions.checkNotNull(description, "IE00326: Description argument can not be null");
    }

    public void addListener(ICodeBookmarkListener listener) {
        this.m_listeners.addListener(listener);
    }

    public IAddress getAddress() {
        return this.m_address;
    }

    public String getDescription() {
        return this.m_description;
    }

    public INaviModule getModule() {
        return this.m_module;
    }

    public void removeListener(ICodeBookmarkListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setDescription(String description) {
        Preconditions.checkNotNull(description, "IE00327: Description argument can not be null");
        if (description.equals(this.m_description)) {
            return;
        }
        this.m_description = description;
        for (ICodeBookmarkListener listener : this.m_listeners) {
            try {
                listener.changedDescription(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

