/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.views;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProviderListener;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.ViewManagerListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.HashMap;
import java.util.Map;

public class ViewManager {
    private static Map<SQLProvider, ViewManager> managers = new HashMap<SQLProvider, ViewManager>();
    private final SQLProvider provider;
    private final SQLProviderListener providerListener = new InternalSQLProviderListener();
    private final ListenerProvider<ViewManagerListener> listeners = new ListenerProvider();
    private final HashBiMap<INaviView, Integer> viewsToId = HashBiMap.create();

    private ViewManager(SQLProvider provider) {
        this.provider = provider;
        this.provider.addListener(this.providerListener);
    }

    public synchronized void addListener(ViewManagerListener listener) {
        this.listeners.addListener(listener);
    }

    public static synchronized ViewManager get(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE02807: provider argument can not be null");
        if (!managers.containsKey(provider)) {
            managers.put(provider, new ViewManager(provider));
        }
        return managers.get(provider);
    }

    private void close() {
        managers.remove(this.provider);
        this.provider.removeListener(this.providerListener);
    }

    public synchronized INaviView getView(int viewId) {
        return (INaviView)this.viewsToId.inverse().get(viewId);
    }

    public synchronized void putView(INaviView view) {
        this.viewsToId.forcePut(view, view.getConfiguration().getId());
    }

    private class InternalSQLProviderListener
    implements SQLProviderListener {
        private InternalSQLProviderListener() {
        }

        @Override
        public void providerClosing(SQLProvider provider) {
            if (ViewManager.this.provider.equals(provider)) {
                ViewManager.this.close();
            }
        }
    }
}

