/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.views;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.ITagListener;
import com.google.security.zynamics.binnavi.Tagging.TagType;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviViewListener;
import com.google.security.zynamics.binnavi.disassembly.views.IViewConfiguration;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public final class CViewConfiguration
implements IViewConfiguration {
    private final INaviView view;
    private final ListenerProvider<INaviViewListener> listeners;
    private final SQLProvider provider;
    private int id;
    private String viewName;
    private String viewDescription;
    private final Date creationDate;
    private Date modificationDate;
    private final ViewType type;
    private INaviModule module;
    private INaviProject project;
    private final Set<CTag> viewTags;
    private boolean isStarred = false;
    private final InternalViewTagListener tagListener = new InternalViewTagListener();

    public CViewConfiguration(INaviView view, ListenerProvider<INaviViewListener> listeners, SQLProvider provider, int viewId, String description, String name, ViewType type, Date creationDate, Date modificationDate, Set<CTag> tags, boolean isStared) {
        this.view = view;
        this.listeners = listeners;
        this.provider = provider;
        this.id = viewId;
        this.viewDescription = description;
        this.viewName = name;
        this.type = type;
        this.creationDate = new Date(creationDate.getTime());
        this.modificationDate = new Date(modificationDate.getTime());
        this.viewTags = new HashSet<CTag>(tags);
        this.isStarred = isStared;
        for (CTag tag : tags) {
            tag.addListener(this.tagListener);
        }
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.creationDate.getTime());
    }

    @Override
    public String getDescription() {
        return this.viewDescription;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Date getModificationDate() {
        return new Date(this.modificationDate.getTime());
    }

    @Override
    public INaviModule getModule() {
        return this.module;
    }

    @Override
    public String getName() {
        return this.viewName;
    }

    @Override
    public INaviProject getProject() {
        return this.project;
    }

    @Override
    public ViewType getType() {
        return this.type;
    }

    @Override
    public Set<CTag> getViewTags() {
        return new HashSet<CTag>(this.viewTags);
    }

    @Override
    public boolean isStared() {
        return this.isStarred;
    }

    public boolean isStored() {
        return Integer.signum(this.id) != -1;
    }

    @Override
    public boolean isTagged() {
        return this.viewTags.size() != 0;
    }

    @Override
    public boolean isTagged(CTag tag) {
        for (CTag t2 : this.viewTags) {
            if (t2.getId() != tag.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDescription(String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(description, "IE00316: Description string can not be null");
        if (description.equals(this.viewDescription)) {
            return;
        }
        if (this.isStored()) {
            this.provider.setDescription(this.view, description);
        }
        this.viewDescription = description;
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.changedDescription(this.view, description);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    @Override
    public void setId(int viewId) {
        this.id = viewId;
    }

    public void setModule(INaviModule module) {
        this.module = module;
    }

    @Override
    public void setName(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00317: Name string can not be null");
        Preconditions.checkArgument(!name.equals(""), "IE00318: Names can not be empty");
        if (name.equals(this.viewName)) {
            return;
        }
        if (this.isStored()) {
            this.provider.setName(this.view, name);
        }
        this.viewName = name;
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.changedName(this.view, name);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    public void setProject(INaviProject project) {
        this.project = project;
    }

    @Override
    public void setStared(boolean isStared) throws CouldntSaveDataException {
        if (this.isStarred == isStared) {
            return;
        }
        this.provider.setStared(this.view, isStared);
        this.isStarred = isStared;
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.changedStarState(this.view, isStared);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void tagView(CTag tag) throws CouldntSaveDataException {
        Preconditions.checkNotNull(tag, "IE00319: Tag argument can not be null");
        Preconditions.checkArgument(tag.inSameDatabase(this.provider), "IE00320: Tag and view are not stored in the same database");
        Preconditions.checkArgument(tag.getType() == TagType.VIEW_TAG, "IE00321: Tag is not a view tag");
        if (!this.viewTags.contains(tag)) {
            if (this.isStored()) {
                this.provider.tagView(this.view, tag);
            }
            tag.addListener(this.tagListener);
            this.viewTags.add(tag);
            for (INaviViewListener listener : this.listeners) {
                try {
                    listener.taggedView(this.view, tag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }

    @Override
    public void untagView(CTag tag) throws CouldntSaveDataException {
        Preconditions.checkNotNull(tag, "IE00322: Tag argument can not be null");
        Preconditions.checkArgument(this.viewTags.contains(tag), "IE00323: View is not tagged by the given tag");
        if (this.isStored()) {
            this.provider.removeTag(this.view, tag);
        }
        tag.removeListener(this.tagListener);
        this.viewTags.remove(tag);
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.untaggedView(this.view, tag);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void updateModificationDate() {
        try {
            this.modificationDate = this.isStored() ? this.provider.getModificationDate(this.view) : new Date();
            for (INaviViewListener listener : this.listeners) {
                try {
                    listener.changedModificationDate(this.view, this.modificationDate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
        catch (CouldntLoadDataException e2) {
            CUtilityFunctions.logException(e2);
        }
    }

    @Override
    public void setNameInternal(String name) {
        Preconditions.checkNotNull(name, "IE02803: name argument can not be null");
        if (this.viewName.equals(name)) {
            return;
        }
        this.viewName = name;
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.changedName(this.view, name);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void setDescriptionInternal(String description) {
        Preconditions.checkNotNull(description, "IE02804: description argument can not be null");
        if (this.viewDescription != null && this.viewDescription.equals(description)) {
            return;
        }
        this.viewDescription = description;
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.changedDescription(this.view, description);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void setStaredInternal(boolean isStared) {
        if (this.isStarred == isStared) {
            return;
        }
        this.isStarred = isStared;
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.changedStarState(this.view, isStared);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void setModificationDateInternal(Date modificationDate) {
        this.modificationDate = Preconditions.checkNotNull(modificationDate, "Error: modificationDate argument can not be null");
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.changedModificationDate(this.view, this.modificationDate);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public int getUnloadedEdgeCount() {
        return 0;
    }

    @Override
    public GraphType getUnloadedGraphType() {
        return null;
    }

    @Override
    public int getUnloadedNodeCount() {
        return 0;
    }

    private class InternalViewTagListener
    implements ITagListener {
        private InternalViewTagListener() {
        }

        @Override
        public void changedDescription(CTag tag, String description) {
        }

        @Override
        public void changedName(CTag tag, String name) {
        }

        @Override
        public void deletedTag(CTag tag) {
            tag.removeListener(CViewConfiguration.this.tagListener);
            CViewConfiguration.this.viewTags.remove(tag);
            for (INaviViewListener listener : CViewConfiguration.this.listeners) {
                try {
                    listener.untaggedView(CViewConfiguration.this.view, tag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

