/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;

public final class TypeMember
implements Comparable<TypeMember> {
    private String name;
    private BaseType baseType;
    private final BaseType parentType;
    private Optional<Integer> offset;
    private Optional<Integer> numberOfElements;
    private Optional<Integer> argumentIndex;
    private final int id;

    private TypeMember(int id, BaseType parentType, BaseType baseType, String name, Optional<Integer> offset, Optional<Integer> numberOfElements, Optional<Integer> argumentIndex) {
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "IE02622: Member name can not be null.");
        this.baseType = Preconditions.checkNotNull(baseType, "IE02623: Base type of member can not be null.");
        this.parentType = Preconditions.checkNotNull(parentType, "IE02624: The parent type can not be null.");
        Preconditions.checkArgument(parentType != baseType, "Error: Cannot create recursive member declaration.");
        this.numberOfElements = Preconditions.checkNotNull(numberOfElements, "Error: number of elements can not be null.");
        Preconditions.checkArgument(!numberOfElements.isPresent() || numberOfElements.get() >= 0, "Error: Number of elements for member must either be greater zero or absent.");
        this.offset = Preconditions.checkNotNull(offset, "Error: offset argument can not be null.");
        this.argumentIndex = Preconditions.checkNotNull(argumentIndex, "Error: argument can not be null.");
        Preconditions.checkArgument(!argumentIndex.isPresent() || argumentIndex.get() >= 0, "Error: Argument index member must either be greater zero or absent.");
        Preconditions.checkArgument(numberOfElements.isPresent() != offset.isPresent() ^ argumentIndex.isPresent(), "Error: Either this is a struct member or an array member, or a prototype argument");
        Preconditions.checkArgument(!offset.isPresent() || offset.get() >= 0, "Error: Member offset must either be greater zero or absent.");
    }

    static TypeMember createStructureMember(int id, BaseType parentType, BaseType baseType, String name, int structureOffset) {
        return new TypeMember(id, parentType, baseType, name, Optional.of(structureOffset), Optional.absent(), Optional.absent());
    }

    static TypeMember createUnionMember(int id, BaseType parentType, BaseType baseType, String name) {
        return new TypeMember(id, parentType, baseType, name, Optional.of(0), Optional.absent(), Optional.absent());
    }

    static TypeMember createFunctionPrototypeMember(int id, BaseType parentType, BaseType baseType, String name, int argumentIndex) {
        return new TypeMember(id, parentType, baseType, name, Optional.absent(), Optional.absent(), Optional.of(argumentIndex));
    }

    static TypeMember createArrayMember(int id, BaseType parentType, BaseType baseType, String name, int numberOfElements) {
        return new TypeMember(id, parentType, baseType, name, Optional.absent(), Optional.of(numberOfElements), Optional.absent());
    }

    static TypeMember createSearchProxy(int offset) {
        return new TypeMember(offset);
    }

    private TypeMember(int offset) {
        this.id = -1;
        this.name = "";
        this.parentType = null;
        this.offset = Optional.of(offset);
        this.numberOfElements = Optional.absent();
        this.argumentIndex = Optional.absent();
    }

    private int compareOptionalInteger(Optional<Integer> lhs, Optional<Integer> rhs) {
        if (!lhs.isPresent() && !rhs.isPresent()) {
            return 0;
        }
        if (!lhs.isPresent()) {
            return -1;
        }
        if (!rhs.isPresent()) {
            return 1;
        }
        return lhs.get().compareTo(rhs.get());
    }

    void setBaseType(BaseType baseType) {
        this.baseType = baseType;
    }

    void setName(String name) {
        this.name = name;
    }

    void setNumberOfElements(Optional<Integer> numberOfElements) {
        Preconditions.checkArgument(this.numberOfElements.isPresent() == numberOfElements.isPresent(), "Error: can not change a non array type to an array type.");
        this.numberOfElements = numberOfElements;
    }

    void setOffset(Optional<Integer> offset) {
        Preconditions.checkArgument(this.offset.isPresent() == offset.isPresent(), "Error: can not change an array type to a non array type and vice versa.");
        this.parentType.deleteMember(this);
        this.offset = offset;
        this.parentType.addMember(this);
    }

    void setArgumentIndex(Optional<Integer> argumentIndex) {
        Preconditions.checkArgument(this.argumentIndex.isPresent() == argumentIndex.isPresent(), "Error: can not change a function prototype type to a non function prototype type.");
        this.argumentIndex = argumentIndex;
    }

    @Override
    public int compareTo(TypeMember rhs) {
        int offsetComparison = this.compareOptionalInteger(this.getBitOffset(), rhs.getBitOffset());
        if (offsetComparison != 0) {
            return offsetComparison;
        }
        int numberOfElementsComparison = this.compareOptionalInteger(this.getNumberOfElements(), rhs.getNumberOfElements());
        if (numberOfElementsComparison != 0) {
            return numberOfElementsComparison;
        }
        int argumentIndexComparison = this.compareOptionalInteger(this.getArgumentIndex(), rhs.getArgumentIndex());
        if (argumentIndexComparison != 0) {
            return argumentIndexComparison;
        }
        return this.getId() - rhs.getId();
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    public int getBitSize() {
        return this.baseType.getBitSize();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getNumberOfElements() {
        return this.numberOfElements;
    }

    public Optional<Integer> getBitOffset() {
        return this.offset;
    }

    public Optional<Integer> getArgumentIndex() {
        return this.argumentIndex;
    }

    public Optional<Integer> getByteOffset() {
        return this.offset.isPresent() ? Optional.of((this.offset.get() + 7) / 8) : this.offset;
    }

    public BaseType getParentType() {
        return this.parentType;
    }

    public boolean isOffsetType() {
        return this.getBitOffset().isPresent();
    }

    public boolean isIndexType() {
        return this.getArgumentIndex().isPresent();
    }

    public String toString() {
        return String.format("%s %s, parent=%s, offset=%d", this.baseType.getName(), this.name, this.parentType.getName(), this.offset.orNull());
    }
}

