/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.RawBaseType;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManagerBackend;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitution;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.List;

public final class TypeManagerDatabaseBackend
implements TypeManagerBackend {
    private final SQLProvider provider;
    private final INaviModule module;

    public TypeManagerDatabaseBackend(SQLProvider provider, INaviModule module) {
        this.provider = Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        this.module = Preconditions.checkNotNull(module, "Error: module argument can not be null");
    }

    @Override
    public BaseType createType(String name, int size, boolean signed, Integer childPointerTypeId, BaseTypeCategory category) throws CouldntSaveDataException {
        int typeId = this.provider.createType(this.module.getConfiguration().getId(), name, size, childPointerTypeId, signed, category);
        return new BaseType(typeId, name, size, signed, category);
    }

    @Override
    public TypeSubstitution createTypeSubstitution(INaviOperandTreeNode node, BaseType baseType, List<Integer> memberPath, int position, int offset, IAddress address) throws CouldntSaveDataException {
        this.provider.createTypeSubstitution(node.getId(), baseType.getId(), memberPath, position, offset, address, this.module);
        return new TypeSubstitution(node, baseType, node.getId(), position, offset, address);
    }

    @Override
    public void deleteMember(TypeMember member) throws CouldntDeleteException {
        this.provider.deleteMember(member, this.module);
    }

    @Override
    public void deleteType(BaseType baseType) throws CouldntDeleteException {
        this.provider.deleteType(baseType, this.module);
    }

    @Override
    public void deleteTypeSubstitution(TypeSubstitution typeSubstitution) throws CouldntDeleteException {
        this.provider.deleteTypeSubstitution(this.module, typeSubstitution);
    }

    @Override
    public BaseType loadRawBaseType(int baseTypeId) throws CouldntLoadDataException {
        RawBaseType rawBaseType = this.provider.loadType(this.module, baseTypeId);
        return new BaseType(rawBaseType.getId(), rawBaseType.getName(), rawBaseType.getSize(), rawBaseType.isSigned(), rawBaseType.getCategory());
    }

    @Override
    public List<RawBaseType> loadRawBaseTypes() throws CouldntLoadDataException {
        return this.provider.loadTypes(this.module);
    }

    @Override
    public RawTypeMember loadRawTypeMember(int typeMemberId) throws CouldntLoadDataException {
        return this.provider.loadTypeMember(this.module, typeMemberId);
    }

    @Override
    public List<RawTypeMember> loadRawTypeMembers() throws CouldntLoadDataException {
        return this.provider.loadTypeMembers(this.module);
    }

    @Override
    public void updateMemberOffsets(List<Integer> updatedMembers, int delta, List<Integer> implicitlyUpdatedMembers, int implicitDela) throws CouldntSaveDataException {
        this.provider.updateMemberOffsets(updatedMembers, delta, implicitlyUpdatedMembers, implicitDela, this.module);
    }

    @Override
    public void updateSubstitution(TypeSubstitution substitution, BaseType baseType, List<Integer> memberPath, int offset) throws CouldntSaveDataException {
        this.provider.updateTypeSubstitution(substitution, baseType, memberPath, offset, this.module);
    }

    @Override
    public void updateType(BaseType baseType, String name, int size, boolean isSigned) throws CouldntSaveDataException {
        this.provider.updateType(baseType, name, size, isSigned, this.module);
    }

    @Override
    public void updateArrayMember(TypeMember member, BaseType baseType, int numberOfElements) throws CouldntSaveDataException {
        this.provider.updateMember(member, member.getName(), baseType, member.getBitOffset(), Optional.of(numberOfElements), member.getArgumentIndex(), this.module);
    }

    @Override
    public TypeMember createFunctionPrototypeMember(BaseType containingType, BaseType memberType, String membeName, int memberArgumentIndex) throws CouldntSaveDataException {
        int typeId = this.provider.createTypeMember(this.module, containingType.getId(), memberType.getId(), membeName, Optional.absent(), Optional.absent(), Optional.of(memberArgumentIndex));
        return TypeMember.createFunctionPrototypeMember(typeId, containingType, memberType, membeName, memberArgumentIndex);
    }

    @Override
    public TypeMember createStructureMember(BaseType containingType, BaseType memberType, String memberName, int memberOffset) throws CouldntSaveDataException {
        int typeId = this.provider.createTypeMember(this.module, containingType.getId(), memberType.getId(), memberName, Optional.of(memberOffset), Optional.absent(), Optional.absent());
        return TypeMember.createStructureMember(typeId, containingType, memberType, memberName, memberOffset);
    }

    @Override
    public TypeMember createUnionMember(BaseType containingType, BaseType memberType, String memberName, int memberOffset) throws CouldntSaveDataException {
        return this.createStructureMember(containingType, memberType, memberName, memberOffset);
    }

    @Override
    public TypeMember createArrayMember(BaseType containingType, BaseType memberType, String memberName, int memberNumberOfElements) throws CouldntSaveDataException {
        int typeId = this.provider.createTypeMember(this.module, containingType.getId(), memberType.getId(), memberName, Optional.absent(), Optional.of(memberNumberOfElements), Optional.absent());
        return TypeMember.createArrayMember(typeId, containingType, memberType, memberName, memberNumberOfElements);
    }

    @Override
    public void updateStructureMember(TypeMember member, BaseType newMemberBaseType, String newMemberName, int newMemberOffset) throws CouldntSaveDataException {
        this.provider.updateMember(member, newMemberName, newMemberBaseType, Optional.of(newMemberOffset), Optional.absent(), Optional.absent(), this.module);
    }

    @Override
    public void updateUnionMember(TypeMember member, BaseType newMemberBaseType, String newMemberName, int newMemberOffset) throws CouldntSaveDataException {
        this.updateStructureMember(member, newMemberBaseType, newMemberName, newMemberOffset);
    }

    @Override
    public void updateFunctionPrototypeMember(TypeMember member, BaseType newMemberBaseType, String newMemberName, int newMemberArgumentIndex) throws CouldntSaveDataException {
        this.provider.updateMember(member, newMemberName, newMemberBaseType, Optional.absent(), Optional.absent(), Optional.of(newMemberArgumentIndex), this.module);
    }
}

