/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.IAddress;

public final class TypeInstanceReference {
    private final IAddress address;
    private final int position;
    private Optional<INaviOperandTreeNode> node;
    private final TypeInstance typeInstance;
    private final INaviView view;

    public TypeInstanceReference(IAddress address, int position, Optional<INaviOperandTreeNode> node, TypeInstance typeInstance, INaviView view) {
        this.address = Preconditions.checkNotNull(address, "Error: address argument can not be null");
        Preconditions.checkArgument(position >= 0, "Error: the operand position must be larger or equal to zero");
        this.position = position;
        this.node = Preconditions.checkNotNull(node, "Error: node argument can not be null");
        this.typeInstance = Preconditions.checkNotNull(typeInstance, "Error: typeInstance argument can not be null");
        this.view = Preconditions.checkNotNull(view, "Error: view argument can not be null");
    }

    public IAddress getAddress() {
        return this.address;
    }

    public int getPosition() {
        return this.position;
    }

    public Optional<INaviOperandTreeNode> getTreeNode() {
        return this.node;
    }

    public TypeInstance getTypeInstance() {
        return this.typeInstance;
    }

    public INaviView getView() {
        return this.view;
    }

    public void setTreeNode(INaviOperandTreeNode node) {
        this.node = Optional.fromNullable(node);
    }

    public String getDisplayableString() {
        String string2 = String.valueOf(this.address.toHexString());
        int n2 = this.position;
        return new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(" Operand ").append(n2).toString();
    }
}

