/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CommentListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceAddress;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainerBackend;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainerListener;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public final class TypeInstanceContainer {
    private final List<TypeInstance> instances = Lists.newArrayList();
    private final Multimap<TypeInstance, TypeInstanceReference> referencesByInstance = ArrayListMultimap.create();
    private final TreeMap<TypeInstanceAddress, TypeInstance> instancesByAddress = new TreeMap();
    private final TypeInstanceContainerBackend backend;
    private final ListenerProvider<TypeInstanceContainerListener> listeners = new ListenerProvider();

    public TypeInstanceContainer(TypeInstanceContainerBackend backend, SQLProvider provider) throws CouldntLoadDataException {
        this.backend = Preconditions.checkNotNull(backend, "Error: backend argument can not be null");
        CommentManager.get(provider).addListener(new InternalCommentListener());
    }

    private void notifyInstanceAdded(TypeInstance instance) {
        for (TypeInstanceContainerListener listener : this.listeners) {
            listener.addedTypeInstance(instance);
        }
    }

    private void notifyInstanceChanged(TypeInstance instance) {
        for (TypeInstanceContainerListener listener : this.listeners) {
            listener.changedTypeInstance(instance);
        }
    }

    private void notifyInstanceRemoved(TypeInstance instance) {
        for (TypeInstanceContainerListener listener : this.listeners) {
            listener.removedTypeInstance(instance);
        }
    }

    private void notifyReferenceAdded(TypeInstanceReference reference) {
        for (TypeInstanceContainerListener listener : this.listeners) {
            listener.addedTypeInstanceReference(reference);
        }
    }

    private void notifyReferenceChanged(TypeInstanceReference reference) {
        for (TypeInstanceContainerListener listener : this.listeners) {
            listener.changedTypeInstanceReference(reference);
        }
    }

    private void notifyReferenceRemoved(TypeInstanceReference reference) {
        for (TypeInstanceContainerListener listener : this.listeners) {
            listener.removedTypeInstanceReference(reference);
        }
    }

    public synchronized void addListener(TypeInstanceContainerListener listener) {
        Preconditions.checkNotNull(listener, "Error: listener argument can not be null");
        this.listeners.addListener(Preconditions.checkNotNull(listener, "Error: listener argument can not be null"));
    }

    public synchronized List<IComment> appendComment(TypeInstance instance, String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        return this.backend.appendComment(instance, commentText);
    }

    public synchronized TypeInstance createInstance(String name, String comment, BaseType baseType, Section section, long sectionOffset) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        Preconditions.checkArgument(comment == null || !comment.isEmpty(), "Error: comment can either be null or a non empty string");
        Preconditions.checkNotNull(baseType, "Error: baseType argument can not be null");
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        Preconditions.checkArgument(sectionOffset >= 0L, "Error: section offset must be greater or equal to zero");
        Preconditions.checkArgument(!this.instancesByAddress.containsKey(new TypeInstanceAddress(section.getStartAddress(), sectionOffset)));
        TypeInstance instance = this.backend.createTypeInstance(name, comment, baseType, section, sectionOffset);
        this.instancesByAddress.put(instance.getAddress(), instance);
        this.instances.add(instance);
        this.notifyInstanceAdded(instance);
        return instance;
    }

    public synchronized TypeInstanceReference createReference(IAddress address, int operandPosition, INaviOperandTreeNode node, TypeInstance instance, INaviView view) throws CouldntSaveDataException {
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        Preconditions.checkArgument(operandPosition >= 0, "Error: operand position must be equal or greater then zero");
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        Preconditions.checkNotNull(instance, "Error: instance argument can not be null");
        TypeInstanceReference reference = this.backend.createTypeInstanceReference(address, operandPosition, node, instance, view);
        this.referencesByInstance.put(instance, reference);
        this.notifyReferenceAdded(reference);
        return reference;
    }

    public synchronized void deactivateTypeInstanceReference(TypeInstanceReference reference) {
        Preconditions.checkNotNull(reference, "Error: reference argument can not be null");
        reference.setTreeNode(null);
        this.notifyReferenceChanged(reference);
    }

    public synchronized void deleteComment(TypeInstance instance, IComment comment) throws CouldntDeleteException {
        this.backend.deleteComment(instance, comment);
    }

    public synchronized void deleteInstance(Integer typeInstanceId) {
        Preconditions.checkNotNull(typeInstanceId, "Error: typeInstanceId argument can not be null");
        TypeInstance backendInstance = this.backend.lookupTypeInstance(typeInstanceId);
        TypeInstance storedTypeInstance = this.instancesByAddress.remove(backendInstance.getAddress());
        this.instances.remove(storedTypeInstance);
        this.backend.deleteInstanceInternal(backendInstance);
        this.notifyInstanceRemoved(storedTypeInstance);
    }

    public synchronized void deleteInstance(TypeInstance instance) throws CouldntDeleteException {
        Preconditions.checkNotNull(instance, "Error: instance argument can not be null");
        this.instancesByAddress.remove(instance.getAddress());
        this.instances.remove(instance);
        this.backend.deleteInstance(instance);
        this.notifyInstanceRemoved(instance);
    }

    public synchronized void deleteReference(Integer typeInstanceId, BigInteger address, Integer position, Integer expressionId) {
        TypeInstanceReference reference = this.backend.lookupReference(new CAddress(address), position, expressionId);
        this.referencesByInstance.remove(reference.getTypeInstance(), reference);
        this.backend.deleteInstanceReferenceInternal(reference);
        reference.setTreeNode(null);
        this.notifyReferenceRemoved(reference);
    }

    public synchronized void deleteReference(TypeInstanceReference reference) throws CouldntDeleteException {
        Preconditions.checkNotNull(reference, "Error: reference argument can not be null");
        this.referencesByInstance.remove(reference.getTypeInstance(), reference);
        this.backend.deleteInstanceReference(reference);
        this.notifyReferenceRemoved(reference);
    }

    public synchronized IComment editComment(TypeInstance instance, IComment comment, String newCommentText) throws CouldntSaveDataException {
        return this.backend.editComment(instance, comment, newCommentText);
    }

    public synchronized List<IComment> getComments(TypeInstance instance) {
        return this.backend.getComments(instance);
    }

    public synchronized int getReferenceCount(TypeInstance typeInstance) {
        Preconditions.checkNotNull(typeInstance, "Error: typeInstance argument can not be null.");
        return this.referencesByInstance.get(typeInstance).size();
    }

    public synchronized List<TypeInstanceReference> getReferences(TypeInstance typeInstance) {
        Preconditions.checkNotNull(typeInstance, "Error: typeInstance argument can not be null.");
        return Collections.unmodifiableList((List)this.referencesByInstance.get(typeInstance));
    }

    public synchronized TypeInstance getTypeInstance(TypeInstanceAddress address) {
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        return this.instancesByAddress.get(address);
    }

    public synchronized TypeInstance getTypeInstanceById(Integer typeInstanceId) {
        return this.backend.lookupTypeInstance(typeInstanceId);
    }

    public synchronized List<TypeInstance> getTypeInstances() {
        return Collections.unmodifiableList(this.instances);
    }

    public synchronized Collection<TypeInstance> getTypeInstances(Section section) {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        return this.instancesByAddress.tailMap(new TypeInstanceAddress(section.getStartAddress(), 0L), true).headMap(new TypeInstanceAddress(section.getStartAddress(), section.getVirtualSize()), false).values();
    }

    public synchronized void initialize() throws CouldntLoadDataException {
        for (TypeInstance instance : this.backend.loadTypeInstances()) {
            this.instancesByAddress.put(instance.getAddress(), instance);
            this.instances.add(instance);
        }
        for (TypeInstanceReference reference : this.backend.loadTypeInstanceReferences()) {
            this.referencesByInstance.put(reference.getTypeInstance(), reference);
        }
    }

    public synchronized void initializeTypeInstanceReference(IAddress address, int operandPosition, int expressionId, INaviOperandTreeNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        TypeInstanceReference reference = this.backend.lookupReference(address, operandPosition, expressionId);
        if (reference != null) {
            reference.setTreeNode(node);
            node.addInstanceReference(reference);
            this.notifyReferenceChanged(reference);
        }
    }

    public synchronized boolean isOwner(IComment comment) {
        return this.backend.isOwner(comment);
    }

    public synchronized TypeInstance loadInstance(Integer typeInstanceId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(typeInstanceId, "Error: typeInstanceId argument can not be null");
        if (this.backend.lookupTypeInstance(typeInstanceId) != null) {
            return this.reloadInstance(typeInstanceId);
        }
        TypeInstance instance = this.backend.loadTypeInstance(typeInstanceId);
        this.instancesByAddress.put(instance.getAddress(), instance);
        this.instances.add(instance);
        this.notifyInstanceAdded(instance);
        return instance;
    }

    public synchronized TypeInstanceReference loadInstanceReference(Integer typeInstanceId, BigInteger address, Integer position, Integer expressionId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(typeInstanceId, "Error: typeInstanceId argument can not be null");
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        Preconditions.checkNotNull(position, "Error: position argument can not be null");
        Preconditions.checkNotNull(expressionId, "Error: expressionId argument can not be null");
        TypeInstanceReference reference = this.backend.loadTypeInstanceReference(typeInstanceId, address, position, expressionId);
        this.referencesByInstance.put(reference.getTypeInstance(), reference);
        return reference;
    }

    public synchronized TypeInstance reloadInstance(Integer typeInstanceId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(typeInstanceId, "Error: typeInstanceId argument can not be null");
        if (this.backend.lookupTypeInstance(typeInstanceId) == null) {
            return this.loadInstance(typeInstanceId);
        }
        TypeInstance instance = this.backend.loadTypeInstance(typeInstanceId);
        TypeInstance storedInstance = this.instancesByAddress.get(instance.getAddress());
        storedInstance.setName(instance.getName());
        this.notifyInstanceChanged(storedInstance);
        return storedInstance;
    }

    public synchronized void removeListener(TypeInstanceContainerListener listener) {
        this.listeners.removeListener(Preconditions.checkNotNull(listener, "Error: listener argument can not be null"));
    }

    public synchronized void setInstanceName(TypeInstance instance, String name) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(instance, "Error: instance argument can not be null");
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        Preconditions.checkArgument(!name.isEmpty(), "Error: name argument can not be empty");
        Preconditions.checkArgument(this.instances.indexOf(instance) != -1, "Error: the given instance is not known.");
        this.backend.setInstanceName(instance, name);
        instance.setName(name);
        this.notifyInstanceChanged(instance);
    }

    private class InternalCommentListener
    extends CommentListenerAdapter {
        private InternalCommentListener() {
        }

        @Override
        public void appendedTypeInstanceComment(TypeInstance instance, IComment comment) {
            TypeInstanceContainer.this.notifyInstanceChanged(instance);
        }

        @Override
        public void initializedTypeInstanceComment(TypeInstance instance, List<IComment> comments) {
            TypeInstanceContainer.this.notifyInstanceChanged(instance);
        }

        @Override
        public void editedTypeInstanceComment(TypeInstance instance, IComment comment) {
            TypeInstanceContainer.this.notifyInstanceChanged(instance);
        }

        @Override
        public void deletedTypeInstanceComment(TypeInstance instance, IComment comment) {
            TypeInstanceContainer.this.notifyInstanceChanged(instance);
        }
    }
}

