/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.SectionPermission;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SectionContainerBackend {
    private final SQLProvider provider;
    private final INaviModule module;

    public SectionContainerBackend(SQLProvider provider, INaviModule module) {
        this.provider = Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        this.module = Preconditions.checkNotNull(module, "Error: module argument can not be null");
    }

    protected Section createSection(String name, IAddress startAddress, IAddress endAddress, SectionPermission permission, byte[] data) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        Preconditions.checkNotNull(startAddress, "Error: start address argument can not be null");
        Preconditions.checkNotNull(endAddress, "Error: end address argument can not be null");
        Preconditions.checkNotNull(permission, "Error: permission argument can not be null");
        int sectionId = this.provider.createSection(this.module.getConfiguration().getId(), name, null, startAddress.toBigInteger(), endAddress.toBigInteger(), permission, data);
        return new Section(sectionId, name, CommentManager.get(this.provider), this.module, startAddress, endAddress, permission, data);
    }

    protected void deleteSection(Section section) throws CouldntLoadDataException {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        this.provider.deleteSection(section);
    }

    protected List<Section> loadSections() throws CouldntLoadDataException {
        Map<Section, Integer> sectionToComment = this.provider.loadSections(this.module);
        Map<Section, Integer> sectionWithCommemnt = Maps.filterValues(sectionToComment, new Predicate<Integer>(){

            @Override
            public boolean apply(Integer commentId) {
                return commentId != null;
            }
        });
        CommentManager manager = CommentManager.get(this.provider);
        HashMap<Integer, ArrayList<IComment>> typeInstanceTocomments = this.provider.loadMultipleCommentsById(sectionWithCommemnt.values());
        for (Map.Entry<Section, Integer> entry : sectionWithCommemnt.entrySet()) {
            manager.initializeSectionComment(entry.getKey(), (List<IComment>)typeInstanceTocomments.get(entry.getValue()));
        }
        return Lists.newArrayList(sectionToComment.keySet());
    }

    protected Section renameSection(Section section, String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        this.provider.setSectionName(this.module.getConfiguration().getId(), section.getId(), name);
        return new Section(section.getId(), name, CommentManager.get(this.provider), this.module, section.getStartAddress(), section.getEndAddress(), section.getSectionPermission(), section.getData());
    }
}

