/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.types.SectionPermission;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.math.BigInteger;
import java.util.List;

public final class Section {
    private final int id;
    private final String name;
    private final IAddress startAddress;
    private final IAddress endAddress;
    private final SectionPermission permission;
    private final byte[] data;
    private final long virtualSize;
    private final CommentManager commentManager;
    private final INaviModule module;

    public Section(int id, String name, CommentManager commentManager, INaviModule module, IAddress startAddress, IAddress endAddress, SectionPermission permission, byte[] data) {
        Preconditions.checkArgument(id >= 0, "Error: id argument must be larger or equal to zero");
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "Error: name argument can not be null");
        this.commentManager = Preconditions.checkNotNull(commentManager, "Error: commentManager argument can not be null");
        this.module = Preconditions.checkNotNull(module, "Error: module argument can not be null");
        Preconditions.checkArgument(startAddress.compareTo(endAddress) <= 0, "Error: end address must be larger or equal to start address");
        this.startAddress = Preconditions.checkNotNull(startAddress, "Error: startAddress argument can not be null");
        this.endAddress = Preconditions.checkNotNull(endAddress, "Error: endAddress argument can not be null");
        this.permission = Preconditions.checkNotNull(permission, "Error: permission argument can not be null");
        this.data = data;
        this.virtualSize = endAddress.toBigInteger().subtract(startAddress.toBigInteger()).longValue();
    }

    public List<IComment> getComments() {
        return this.commentManager.getSectionComments(this);
    }

    public byte[] getData() {
        return this.data;
    }

    public IAddress getEndAddress() {
        return this.endAddress;
    }

    public int getId() {
        return this.id;
    }

    public INaviModule getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public int getRawSize() {
        return this.data != null ? this.data.length : 0;
    }

    public SectionPermission getSectionPermission() {
        return this.permission;
    }

    public IAddress getStartAddress() {
        return this.startAddress;
    }

    public long getVirtualSize() {
        return this.virtualSize;
    }

    public boolean isValidOffset(long offset) {
        if (offset < 0L) {
            return false;
        }
        return BigInteger.valueOf(offset).compareTo(BigInteger.valueOf(this.virtualSize)) < 0;
    }

    public boolean isValidAddress(Long address) {
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        return address >= this.startAddress.toLong() && address <= this.endAddress.toLong();
    }
}

