/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProviderListener;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.HashMap;
import java.util.Map;

public class FunctionManager {
    private static Map<SQLProvider, FunctionManager> managers = new HashMap<SQLProvider, FunctionManager>();
    private final SQLProvider provider;
    private final SQLProviderListener providerListener = new InternalSQLProviderListener();
    private final HashBiMap<INaviFunction, Pair<IAddress, Integer>> functionsToAddressModule = HashBiMap.create();

    private FunctionManager(SQLProvider provider) {
        this.provider = provider;
        this.provider.addListener(this.providerListener);
    }

    private void close() {
        managers.remove(this.provider);
        this.provider.removeListener(this.providerListener);
    }

    public static synchronized FunctionManager get(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE02755: provider argument can not be null");
        if (!managers.containsKey(provider)) {
            managers.put(provider, new FunctionManager(provider));
        }
        return managers.get(provider);
    }

    public synchronized INaviFunction getFunction(IAddress address, int moduleId) {
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        return (INaviFunction)this.functionsToAddressModule.inverse().get(new Pair<IAddress, Integer>(address, moduleId));
    }

    public synchronized void putFunction(INaviFunction function) {
        this.functionsToAddressModule.forcePut(function, new Pair<IAddress, Integer>(function.getAddress(), function.getModule().getConfiguration().getId()));
    }

    private class InternalSQLProviderListener
    implements SQLProviderListener {
        private InternalSQLProviderListener() {
        }

        @Override
        public void providerClosing(SQLProvider provider) {
            if (FunctionManager.this.provider.equals(provider)) {
                FunctionManager.this.close();
            }
        }
    }
}

