/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.algorithms;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.CGroupNode;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewEdge;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CNodeTypeSwitcher;
import com.google.security.zynamics.binnavi.disassembly.algorithms.INodeTypeCallback;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CBend;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionMapper;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CViewInserter {
    private CViewInserter() {
    }

    private static void createEdges(INaviView target, List<INaviEdge> edges, Map<INaviViewNode, INaviViewNode> nodeMap) {
        for (INaviEdge edge : edges) {
            INaviViewNode sourceNode = nodeMap.get(edge.getSource());
            INaviViewNode targetNode = nodeMap.get(edge.getTarget());
            CNaviViewEdge newEdge = target.getContent().createEdge(sourceNode, targetNode, edge.getType());
            newEdge.setColor(edge.getColor());
            newEdge.setX1(edge.getX1());
            newEdge.setY1(edge.getY1());
            newEdge.setX2(edge.getX2());
            newEdge.setY2(edge.getY2());
            for (CBend bend : edge.getBends()) {
                newEdge.addBend(bend.getX(), bend.getY());
            }
        }
    }

    private static void createGroupNodes(INaviView target, Collection<INaviViewNode> sourceNodes, Map<INaviViewNode, INaviViewNode> nodeMap) {
        for (INaviViewNode blockNode : sourceNodes) {
            if (!(blockNode instanceof INaviGroupNode)) continue;
            INaviGroupNode gnode = (INaviGroupNode)blockNode;
            CGroupNode newGroupNode = target.getContent().createGroupNode(CViewInserter.getNodes(gnode.getElements(), nodeMap));
            newGroupNode.initializeComment(gnode.getComments());
        }
    }

    private static Map<INaviViewNode, INaviViewNode> createNodes(INaviView target, Collection<INaviViewNode> nodes) {
        HashMap<INaviViewNode, INaviViewNode> map = new HashMap<INaviViewNode, INaviViewNode>();
        for (INaviViewNode blockNode : nodes) {
            CViewInserter.createNodes(target, blockNode, map);
        }
        return map;
    }

    private static void createNodes(final INaviView target, INaviViewNode sourceNode, Map<INaviViewNode, INaviViewNode> nodeMap) {
        INaviViewNode newNode = CNodeTypeSwitcher.switchNode(sourceNode, new INodeTypeCallback<INaviViewNode>(){

            @Override
            public INaviViewNode handle(INaviCodeNode node) {
                return CViewInserter.insertCodeNode(target, node);
            }

            @Override
            public INaviViewNode handle(INaviFunctionNode node) {
                return CViewInserter.insertFunctionNode(target, node);
            }

            @Override
            public INaviViewNode handle(INaviGroupNode node) {
                return null;
            }

            @Override
            public INaviViewNode handle(INaviTextNode node) {
                return CViewInserter.insertTextNode(target, node);
            }
        });
        if (newNode != null) {
            newNode.setBorderColor(sourceNode.getBorderColor());
            newNode.setColor(sourceNode.getColor());
            newNode.setHeight(sourceNode.getHeight());
            newNode.setSelected(sourceNode.isSelected());
            newNode.setVisible(sourceNode.isVisible());
            newNode.setWidth(sourceNode.getWidth());
            newNode.setX(sourceNode.getX());
            newNode.setY(sourceNode.getY());
            nodeMap.put(sourceNode, newNode);
        }
    }

    private static Collection<INaviViewNode> getNodes(List<INaviViewNode> sourceNodes, final Map<INaviViewNode, INaviViewNode> nodeMap) {
        return CollectionHelpers.map(sourceNodes, new ICollectionMapper<INaviViewNode, INaviViewNode>(){

            @Override
            public INaviViewNode map(INaviViewNode item) {
                return (INaviViewNode)nodeMap.get(item);
            }
        });
    }

    private static INaviCodeNode insertCodeNode(INaviView target, INaviCodeNode node) {
        CCodeNode codeNode;
        INaviCodeNode sourceNode = (INaviCodeNode)node.cloneNode();
        Iterable instructions = sourceNode.getInstructions();
        ArrayList instructionList = Lists.newArrayList(instructions);
        try {
            codeNode = target.getContent().createCodeNode(sourceNode.getParentFunction(), instructionList);
        }
        catch (MaybeNullException e2) {
            codeNode = target.getContent().createCodeNode(null, instructionList);
        }
        if (sourceNode.getComments().getGlobalCodeNodeComment() != null) {
            codeNode.getComments().initializeGlobalCodeNodeComment(sourceNode.getComments().getGlobalCodeNodeComment());
        }
        if (sourceNode.getComments().getLocalCodeNodeComment() != null) {
            codeNode.getComments().initializeLocalCodeNodeComment(sourceNode.getComments().getLocalCodeNodeComment());
        }
        Iterable<INaviInstruction> newInstructions = codeNode.getInstructions();
        for (int i2 = 0; i2 < Iterables.size(instructions); ++i2) {
            codeNode.getComments().initializeLocalInstructionComment(Iterables.get(newInstructions, i2), sourceNode.getComments().getLocalInstructionComment((INaviInstruction)Iterables.get(instructions, i2)));
        }
        return codeNode;
    }

    private static CNaviViewNode insertFunctionNode(INaviView target, INaviFunctionNode sourceNode) {
        CFunctionNode node = target.getContent().createFunctionNode(sourceNode.getFunction());
        if (sourceNode.getLocalFunctionComment() != null) {
            node.initializeLocalFunctionComment(sourceNode.getLocalFunctionComment());
        }
        return node;
    }

    private static CNaviViewNode insertTextNode(INaviView target, INaviTextNode sourceNode) {
        return target.getContent().createTextNode(sourceNode.getComments());
    }

    public static void insertView(INaviView source, INaviView target) {
        Preconditions.checkNotNull(source, "IE00007: Source argument can not be null");
        Preconditions.checkNotNull(target, "IE00020: Target argument can not be null");
        Preconditions.checkArgument(source.isLoaded(), "IE00974: Source view must be loaded");
        Preconditions.checkArgument(target.isLoaded(), "IE00978: Target view must be loaded");
        IDirectedGraph<INaviViewNode, INaviEdge> graph = source.getGraph();
        Map<INaviViewNode, INaviViewNode> map = CViewInserter.createNodes(target, graph.getNodes());
        CViewInserter.createEdges(target, graph.getEdges(), map);
        CViewInserter.createGroupNodes(target, graph.getNodes(), map);
    }
}

