/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.algorithms;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphLayouter;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;

public class CUnInliner {
    private CUnInliner() {
    }

    private static INaviCodeNode getEndNode(INaviCodeNode node) {
        try {
            return CUnInliner.getEndNode(node, node.getParentFunction(), new HashSet<INaviCodeNode>());
        }
        catch (MaybeNullException e2) {
            return null;
        }
    }

    private static INaviCodeNode getEndNode(INaviCodeNode node, INaviFunction originalFunction, Set<INaviCodeNode> visited) {
        if (visited.contains(node)) {
            return null;
        }
        visited.add(node);
        for (INaviEdge outgoingEdge : node.getOutgoingEdges()) {
            if (outgoingEdge.getType() != EdgeType.LEAVE_INLINED_FUNCTION) continue;
            try {
                if (node.getParentFunction() != originalFunction) continue;
                if (outgoingEdge.getTarget() instanceof INaviCodeNode) {
                    return (INaviCodeNode)outgoingEdge.getTarget();
                }
                return null;
            }
            catch (MaybeNullException maybeNullException) {
            }
        }
        for (INaviEdge outgoingEdge : node.getOutgoingEdges()) {
            INaviCodeNode endNode;
            if (!(outgoingEdge.getTarget() instanceof INaviCodeNode) || (endNode = CUnInliner.getEndNode((INaviCodeNode)outgoingEdge.getTarget(), originalFunction, visited)) == null) continue;
            return endNode;
        }
        return null;
    }

    private static INaviFunction getParentFunction(INaviCodeNode node) {
        try {
            return node.getParentFunction();
        }
        catch (MaybeNullException e2) {
            return null;
        }
    }

    private static INaviCodeNode searchForSourceNodeOfEnterInlinedEdge(INaviCodeNode node) {
        try {
            return CUnInliner.searchForSourceNodeOfEnterInlinedEdge(node, node.getParentFunction(), new HashSet<INaviCodeNode>());
        }
        catch (MaybeNullException e2) {
            return null;
        }
    }

    private static INaviCodeNode searchForSourceNodeOfEnterInlinedEdge(INaviCodeNode node, INaviFunction originalFunction, Set<INaviCodeNode> visited) {
        if (visited.contains(node)) {
            return null;
        }
        visited.add(node);
        for (INaviEdge incomingEdge : node.getIncomingEdges()) {
            if (incomingEdge.getType() != EdgeType.ENTER_INLINED_FUNCTION) continue;
            if (incomingEdge.getSource() instanceof INaviCodeNode) {
                return (INaviCodeNode)incomingEdge.getSource();
            }
            return null;
        }
        for (INaviEdge incomingEdge : node.getIncomingEdges()) {
            INaviCodeNode startNode;
            if (!(incomingEdge.getSource() instanceof INaviCodeNode) || (startNode = CUnInliner.searchForSourceNodeOfEnterInlinedEdge((INaviCodeNode)incomingEdge.getSource(), originalFunction, visited)) == null) continue;
            return startNode;
        }
        return null;
    }

    private static boolean hasDifferentParentFunctions(INaviCodeNode firstNode, INaviCodeNode secondNode) {
        try {
            INaviFunction startFunction = firstNode.getParentFunction();
            try {
                INaviFunction endFunction = secondNode.getParentFunction();
                return !startFunction.equals(endFunction);
            }
            catch (MaybeNullException e2) {
                return true;
            }
        }
        catch (MaybeNullException e3) {
            try {
                secondNode.getParentFunction();
                return true;
            }
            catch (MaybeNullException e1) {
                return false;
            }
        }
    }

    private static void removeTextNodes(INaviView view, ImmutableList<INaviViewNode> nodes) {
        HashSet<INaviViewNode> toDelete = new HashSet<INaviViewNode>();
        for (INaviViewNode node : nodes) {
            for (INaviViewNode parent : node.getParents()) {
                if (!(parent instanceof INaviTextNode)) continue;
                toDelete.add(parent);
            }
        }
        view.getContent().deleteNodes(toDelete);
    }

    public static CInlinedNodes getInlinedNodes(INaviCodeNode node) {
        Preconditions.checkNotNull(node, "IE02750: node argument can not be null");
        INaviCodeNode startNode = CUnInliner.searchForSourceNodeOfEnterInlinedEdge(node);
        INaviCodeNode endNode = CUnInliner.getEndNode(node);
        if (startNode == null || endNode == null) {
            return null;
        }
        if (CUnInliner.hasDifferentParentFunctions(startNode, endNode)) {
            NaviLogger.info("Uninlining yielded almost certainly incorrect results.", new Object[0]);
        }
        Set<INaviViewNode> preds = GraphAlgorithms.getPredecessorsUpToNode(endNode, startNode);
        Set<INaviViewNode> succs = GraphAlgorithms.getSuccessorsDownToNode(startNode, endNode);
        preds.retainAll(succs);
        return new CInlinedNodes(startNode, endNode, ImmutableList.copyOf(preds));
    }

    public static boolean unInline(INaviView view, INaviCodeNode node) {
        try {
            boolean mergeBlocks;
            CInlinedNodes inlinedNodes = CUnInliner.getInlinedNodes(node);
            if (inlinedNodes == null) {
                return false;
            }
            ArrayList instructions = Lists.newArrayList(inlinedNodes.getStartNode().getInstructions());
            boolean bl2 = mergeBlocks = inlinedNodes.getEndNode().getIncomingEdges().size() == 1;
            if (mergeBlocks) {
                instructions.addAll(Lists.newArrayList(inlinedNodes.getEndNode().getInstructions()));
            }
            CCodeNode combinedNode = view.getContent().createCodeNode(CUnInliner.getParentFunction(inlinedNodes.getStartNode()), instructions);
            combinedNode.setColor(inlinedNodes.getStartNode().getColor());
            combinedNode.setBorderColor(inlinedNodes.getStartNode().getBorderColor());
            CUnInliner.removeTextNodes(view, inlinedNodes.getInlinedNodes());
            view.getContent().deleteNodes(inlinedNodes.getInlinedNodes());
            for (INaviEdge incomingEdge : inlinedNodes.getStartNode().getIncomingEdges()) {
                view.getContent().createEdge((INaviViewNode)incomingEdge.getSource(), combinedNode, incomingEdge.getType());
            }
            if (mergeBlocks) {
                for (INaviEdge outgoingEdge : inlinedNodes.getEndNode().getOutgoingEdges()) {
                    view.getContent().createEdge(combinedNode, (INaviViewNode)outgoingEdge.getTarget(), outgoingEdge.getType());
                }
            } else {
                view.getContent().createEdge(combinedNode, inlinedNodes.getEndNode(), EdgeType.JUMP_UNCONDITIONAL);
            }
            view.getContent().deleteNode(inlinedNodes.getStartNode());
            if (mergeBlocks) {
                view.getContent().deleteNode(inlinedNodes.getEndNode());
            }
            return true;
        }
        catch (IllegalStateException exception) {
            CUtilityFunctions.logException(exception);
            return false;
        }
    }

    public static void unInline(JFrame parent, ZyGraph graph, INaviCodeNode node) {
        CUnInliner.unInline(graph.getRawView(), node);
        if (graph.getSettings().getLayoutSettings().getAutomaticLayouting()) {
            CGraphLayouter.refreshLayout(parent, graph);
        }
    }

    private static class CInlinedNodes {
        private final INaviCodeNode m_startNode;
        private final INaviCodeNode m_endNode;
        private final ImmutableList<INaviViewNode> m_inlinedNodes;

        private CInlinedNodes(INaviCodeNode startNode, INaviCodeNode endNode, ImmutableList<INaviViewNode> inlinedNodes) {
            this.m_startNode = Preconditions.checkNotNull(startNode, "IE02752: startNode argument can not be null");
            this.m_endNode = Preconditions.checkNotNull(endNode, "IE02753: endNode argument can not be null");
            this.m_inlinedNodes = Preconditions.checkNotNull(inlinedNodes, "IE02754: inlinedNodes argument can not be null");
        }

        public INaviCodeNode getEndNode() {
            return this.m_endNode;
        }

        public ImmutableList<INaviViewNode> getInlinedNodes() {
            return this.m_inlinedNodes;
        }

        public INaviCodeNode getStartNode() {
            return this.m_startNode;
        }
    }
}

