/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.algorithms;

import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.disassembly.IReference;
import com.google.security.zynamics.zylib.disassembly.ReferenceType;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CReferenceFinder {
    private CReferenceFinder() {
    }

    private static void fetchReferenceList(IOperandTreeNode node, INaviInstruction instruction, List<Pair<INaviInstruction, INaviFunction>> functions) {
        List<IReference> references = node.getReferences();
        for (IReference iReference : references) {
            if (!ReferenceType.isCodeReference(iReference.getType())) continue;
            IAddress target = iReference.getTarget();
            INaviFunction function = instruction.getModule().getContent().getFunctionContainer().getFunction(target);
            if (function == null) continue;
            functions.add(new Pair<INaviInstruction, INaviFunction>(instruction, function));
        }
        for (IOperandTreeNode iOperandTreeNode : node.getChildren()) {
            CReferenceFinder.fetchReferenceList(iOperandTreeNode, instruction, functions);
        }
    }

    private static void fetchReferenceMap(IOperandTreeNode node, INaviInstruction instruction, Map<INaviInstruction, INaviFunction> functions) {
        List<IReference> references = node.getReferences();
        for (IReference iReference : references) {
            if (!ReferenceType.isCodeReference(iReference.getType())) continue;
            IAddress target = iReference.getTarget();
            INaviFunction function = instruction.getModule().getContent().getFunctionContainer().getFunction(target);
            if (function == null) continue;
            functions.put(instruction, function);
        }
        for (IOperandTreeNode iOperandTreeNode : node.getChildren()) {
            CReferenceFinder.fetchReferenceMap(iOperandTreeNode, instruction, functions);
        }
    }

    public static List<Pair<INaviInstruction, INaviFunction>> getCodeReferenceList(INaviCodeNode node) {
        ArrayList<Pair<INaviInstruction, INaviFunction>> functions = new ArrayList<Pair<INaviInstruction, INaviFunction>>();
        for (INaviInstruction instruction : node.getInstructions()) {
            for (IOperandTree iOperandTree : instruction.getOperands()) {
                CReferenceFinder.fetchReferenceList(iOperandTree.getRootNode(), instruction, functions);
            }
        }
        return functions;
    }

    public static HashMap<INaviInstruction, INaviFunction> getCodeReferenceMap(INaviCodeNode node) {
        HashMap<INaviInstruction, INaviFunction> references = new HashMap<INaviInstruction, INaviFunction>();
        for (INaviInstruction instruction : node.getInstructions()) {
            for (IOperandTree iOperandTree : instruction.getOperands()) {
                CReferenceFinder.fetchReferenceMap(iOperandTree.getRootNode(), instruction, references);
            }
        }
        return references;
    }
}

