/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.algorithms;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import java.awt.Color;

public final class CFunctionNodeColorizer {
    private CFunctionNodeColorizer() {
    }

    public static Color getFunctionColor(FunctionType type) {
        Preconditions.checkNotNull(type, "IE02200: Type argument cannot be null");
        switch (type) {
            case ADJUSTOR_THUNK: {
                return ConfigManager.instance().getColorSettings().getAdjustorThunkFunctionColor();
            }
            case IMPORT: {
                return ConfigManager.instance().getColorSettings().getImportedFunctionColor();
            }
            case LIBRARY: {
                return ConfigManager.instance().getColorSettings().getLibraryFunctionColor();
            }
            case NORMAL: {
                return ConfigManager.instance().getColorSettings().getNormalFunctionColor();
            }
            case THUNK: {
                return ConfigManager.instance().getColorSettings().getThunkFunctionColor();
            }
            case UNKNOWN: {
                return ConfigManager.instance().getColorSettings().getUnknownFunctionColor();
            }
        }
        throw new IllegalStateException(String.format("IE00908: Unknown function type %s", new Object[]{type}));
    }
}

