/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.algorithms;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.reil.ReilFunction;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.OperandGraph;
import com.google.security.zynamics.reil.algorithms.mono.OperandGraphEdge;
import com.google.security.zynamics.reil.algorithms.mono.OperandGraphNode;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import java.util.HashMap;

public final class CDataflowViewCreator {
    private CDataflowViewCreator() {
    }

    public static INaviView create(IViewContainer container, INaviView view) throws InternalTranslationException {
        Preconditions.checkNotNull(container, "IE00411: Module argument can not be null");
        Preconditions.checkNotNull(view, "IE00414: View argument can not be null");
        HashMap<IAddress, INaviInstruction> instructions = new HashMap<IAddress, INaviInstruction>();
        for (CCodeNode codeNode : view.getBasicBlocks()) {
            for (INaviInstruction instruction : codeNode.getInstructions()) {
                instructions.put(instruction.getAddress(), instruction);
            }
        }
        ReilFunction function = view.getContent().getReilCode();
        OperandGraph operandGraph = OperandGraph.create(function.getGraph());
        INaviView dfView = container.createView(String.format("Data flow view of '%s'", view.getName()), "");
        HashMap nodeMap = new HashMap();
        HashMap<INaviInstruction, CCodeNode> instructionMap = new HashMap<INaviInstruction, CCodeNode>();
        for (OperandGraphNode operandGraphNode : operandGraph) {
            ReilInstruction reilInstruction = operandGraphNode.getInstruction();
            INaviInstruction instruction = (INaviInstruction)instructions.get(ReilHelpers.toNativeAddress(reilInstruction.getAddress()));
            if (instructionMap.containsKey(instruction)) {
                nodeMap.put(operandGraphNode, instructionMap.get(instruction));
                continue;
            }
            CCodeNode codeNode = dfView.getContent().createCodeNode(null, Lists.newArrayList(instruction));
            codeNode.setColor(ConfigManager.instance().getColorSettings().getBasicBlocksColor());
            nodeMap.put(operandGraphNode, codeNode);
            instructionMap.put(instruction, codeNode);
        }
        for (OperandGraphEdge edge : operandGraph.getEdges()) {
            INaviCodeNode target;
            INaviCodeNode source = (INaviCodeNode)nodeMap.get(edge.getSource());
            if (source.equals(target = (INaviCodeNode)nodeMap.get(edge.getTarget()))) continue;
            dfView.getContent().createEdge(source, target, EdgeType.JUMP_UNCONDITIONAL);
        }
        return dfView;
    }
}

