/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.Modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CModuleViewGenerator;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviViewListener;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class CViewContainer {
    private final INaviModule m_module;
    private final ICallgraphView m_nativeCallgraphView;
    private final ImmutableBiMap<INaviView, INaviFunction> m_viewFunctionBiMap;
    private final ImmutableList<IFlowgraphView> m_nativeFlowgraphs;
    private final List<INaviView> m_customViews;
    private final INaviViewListener m_viewListener = new InternalViewListener();
    private final ListenerProvider<IModuleListener> m_listeners;
    private final Map<Integer, INaviView> viewIdView = Maps.newHashMap();
    private final SQLProvider m_provider;

    public CViewContainer(INaviModule module, ICallgraphView nativeCallgraph, ImmutableList<IFlowgraphView> nativeFlowgraphs, List<INaviView> customViews, ImmutableBiMap<INaviView, INaviFunction> viewFunctionBiMap, ListenerProvider<IModuleListener> listeners, SQLProvider provider) {
        this.m_module = Preconditions.checkNotNull(module, "IE02395: module argument can not be null");
        this.m_listeners = listeners;
        this.m_provider = Preconditions.checkNotNull(provider, "IE02396: provider argument can not be null");
        this.m_nativeCallgraphView = nativeCallgraph;
        this.viewIdView.put(nativeCallgraph.getConfiguration().getId(), nativeCallgraph);
        this.m_nativeFlowgraphs = nativeFlowgraphs;
        this.m_customViews = customViews;
        this.m_viewFunctionBiMap = viewFunctionBiMap;
        for (INaviView iNaviView : this.m_customViews) {
            iNaviView.addListener(this.m_viewListener);
            this.viewIdView.put(iNaviView.getConfiguration().getId(), iNaviView);
        }
        for (INaviView iNaviView : this.m_nativeFlowgraphs) {
            iNaviView.addListener(this.m_viewListener);
            this.viewIdView.put(iNaviView.getConfiguration().getId(), iNaviView);
        }
    }

    private static boolean closeViews(List<? extends INaviView> views) {
        for (INaviView iNaviView : new FilledList<INaviView>((Collection<? extends INaviView>)views)) {
            if (!iNaviView.isLoaded() || iNaviView.close()) continue;
            return false;
        }
        return true;
    }

    public void addView(INaviView view) {
        Preconditions.checkNotNull(view, "IE00151: View can not be null");
        Preconditions.checkArgument(view.getType() != ViewType.Native, "IE00152: Only non-native views can be added to modules");
        Preconditions.checkArgument(!this.m_customViews.contains(view), "IE00154: View can not be added to the module more than once");
        Preconditions.checkArgument(view.inSameDatabase(this.m_provider), "IE00155: View and module are not in the same database");
        this.m_customViews.add(view);
        if (view.getConfiguration().getId() != -1) {
            this.viewIdView.put(view.getConfiguration().getId(), view);
        }
        view.addListener(this.m_viewListener);
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.addedView(this.m_module, view);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public boolean close() {
        if (this.m_nativeCallgraphView.isLoaded() && !this.m_nativeCallgraphView.close()) {
            return false;
        }
        if (!CViewContainer.closeViews(this.m_nativeFlowgraphs)) {
            return false;
        }
        if (!CViewContainer.closeViews(this.m_customViews)) {
            return false;
        }
        for (INaviView iNaviView : this.m_customViews) {
            iNaviView.removeListener(this.m_viewListener);
        }
        for (INaviView iNaviView : this.m_nativeFlowgraphs) {
            iNaviView.removeListener(this.m_viewListener);
        }
        return true;
    }

    public CView createView(String name, String description) {
        Preconditions.checkNotNull(name, "IE00164: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE00165: Name description can not be null");
        Date date = new Date();
        CModuleViewGenerator generator2 = new CModuleViewGenerator(this.m_provider, this.m_module);
        CView view = generator2.generate(-1, name, description, ViewType.NonNative, GraphType.MIXED_GRAPH, date, date, 0, 0, new HashSet<CTag>(), new HashSet<CTag>(), false);
        try {
            view.load();
        }
        catch (CPartialLoadException | CouldntLoadDataException | LoadCancelledException e2) {
            CUtilityFunctions.logException(e2);
        }
        this.addView(view);
        return view;
    }

    public void deleteView(INaviView view) throws CouldntDeleteException {
        this.checkDeleteArguments(view);
        if (view.getConfiguration().getId() != -1) {
            this.m_provider.deleteView(view);
        }
        this.delete(view);
    }

    public void deleteViewInternal(INaviView view) {
        Preconditions.checkNotNull(view, "IE02756: View argument can not be null");
        if (view.getType() == ViewType.Native) {
            return;
        }
        Preconditions.checkArgument(this.m_customViews.contains(view), "IE00172: View is not part of the module");
        this.delete(view);
    }

    private void checkDeleteArguments(INaviView view) {
        Preconditions.checkNotNull(view, "IE00169: View argument can not be null");
        Preconditions.checkState(view.getType() == ViewType.NonNative, "IE00171: Only non-native views can be deleted");
        Preconditions.checkArgument(this.m_customViews.contains(view), "IE00172: View is not part of the module");
    }

    private void delete(INaviView view) {
        INaviView currentStoredView = this.m_customViews.get(this.m_customViews.indexOf(view));
        this.m_customViews.remove(currentStoredView);
        this.viewIdView.remove(view.getConfiguration().getId());
        currentStoredView.removeListener(this.m_viewListener);
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.deletedView(this.m_module, currentStoredView);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public int getCustomViewCount() {
        return this.m_customViews.size();
    }

    public INaviFunction getFunction(INaviView view) {
        return (INaviFunction)this.m_viewFunctionBiMap.get(Preconditions.checkNotNull(view, "IE00174: View argument can not be null"));
    }

    public ICallgraphView getNativeCallgraphView() {
        return this.m_nativeCallgraphView;
    }

    public ImmutableList<IFlowgraphView> getNativeFlowgraphViews() {
        return this.m_nativeFlowgraphs;
    }

    public List<INaviView> getUserViews() {
        return new ArrayList<INaviView>(this.m_customViews);
    }

    public INaviView getView(INaviFunction function) {
        Preconditions.checkNotNull(function, "IE00186: Function argument can not be null");
        Preconditions.checkArgument(function.inSameDatabase(this.m_provider), "IE00188: Function and module are not in the same database");
        return (INaviView)((ImmutableMap)((Object)this.m_viewFunctionBiMap.inverse())).get(function);
    }

    public List<INaviView> getViews() {
        ArrayList<INaviView> views = new ArrayList<INaviView>();
        views.add(this.m_nativeCallgraphView);
        views.addAll(this.m_nativeFlowgraphs);
        views.addAll(this.m_customViews);
        return views;
    }

    public INaviView getView(Integer viewId) {
        Preconditions.checkNotNull(viewId, "Error: viewId argument can not be null");
        Preconditions.checkArgument(viewId > 0, "Error: only saved views can be querried by id");
        return this.viewIdView.get(viewId);
    }

    public boolean hasView(INaviView view) {
        Preconditions.checkNotNull(view, "IE00190: View argument can not be null");
        Preconditions.checkArgument(view.inSameDatabase(this.m_provider), "IE00192: View and module are not in the same database");
        return view == this.m_nativeCallgraphView || this.m_customViews.contains(view) || this.m_nativeFlowgraphs.contains(view);
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        @Override
        public void changedDescription(INaviView view, String description) {
            INaviFunction function = CViewContainer.this.getFunction(view);
            if (function != null) {
                try {
                    function.setDescription(description);
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void changedName(INaviView view, String name) {
            INaviFunction function = CViewContainer.this.getFunction(view);
            if (function != null) {
                try {
                    function.setName(name);
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void closedView(INaviView view, IDirectedGraph<INaviViewNode, INaviEdge> oldGraph) {
            if (view.getConfiguration().getId() == -1) {
                CViewContainer.this.m_customViews.remove(view);
                view.removeListener(this);
            }
        }
    }
}

