/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.Modules;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.ITraceContainerListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class CTraceContainer {
    private final INaviModule m_module;
    private final IFilledList<TraceList> m_traces;
    private final ListenerProvider<ITraceContainerListener> m_listeners = new ListenerProvider();
    private final SQLProvider m_provider;

    public CTraceContainer(INaviModule module, List<TraceList> traces, SQLProvider provider) {
        this.m_module = Preconditions.checkNotNull(module, "IE01694: module argument can not be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE01695: provider argument can not be null");
        this.m_traces = new FilledList<TraceList>((Collection<TraceList>)traces);
    }

    public void addListener(ITraceContainerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public TraceList createTrace(String name, String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00157: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE00158: Description argument can not be null");
        TraceList trace2 = this.m_provider.createTrace(this.m_module, name, description);
        this.m_traces.add(trace2);
        for (ITraceContainerListener listener : this.m_listeners) {
            try {
                listener.addedTrace(this, trace2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_module.getConfiguration().updateModificationDate();
        return trace2;
    }

    public void deleteTrace(TraceList trace2) throws CouldntDeleteException {
        Preconditions.checkNotNull(trace2, "IE00167: Trace argument can not be null");
        Preconditions.checkArgument(this.m_traces.contains(trace2), "IE00168: Trace is not part of this module");
        this.m_provider.deleteTrace(trace2);
        this.m_traces.remove(trace2);
        for (ITraceContainerListener listener : this.m_listeners) {
            try {
                listener.deletedTrace(this, trace2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public int getTraceCount() {
        return this.m_traces.size();
    }

    public List<TraceList> getTraces() {
        return new ArrayList<TraceList>(this.m_traces);
    }

    public void removeListener(ITraceContainerListener listener) {
        this.m_listeners.removeListener(listener);
    }
}

