/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.Modules;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.ModuleTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.TcpDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviModuleConfiguration;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.Date;

public final class CModuleConfiguration
implements INaviModuleConfiguration {
    private final INaviModule m_module;
    private final SQLProvider m_provider;
    private final ListenerProvider<IModuleListener> m_listeners;
    private final int m_id;
    private String m_name;
    private String m_description;
    private final Date m_creationDate;
    private Date m_modificationDate;
    private final String m_md5;
    private final String m_sha1;
    private IAddress m_fileBase;
    private IAddress m_imageBase;
    private boolean m_isStared;
    private DebuggerTemplate m_debuggerTemplate = null;
    private TcpDebugger m_debugger = null;
    private final INaviRawModule m_rawModule;

    public CModuleConfiguration(INaviModule module, SQLProvider provider, ListenerProvider<IModuleListener> listeners, int moduleId, String name, String comment, Date creationDate, Date modificationDate, String md52, String sha1, IAddress fileBase, IAddress imageBase, DebuggerTemplate debuggerTemplate, boolean isStared, INaviRawModule rawModule) {
        this.m_module = module;
        this.m_provider = provider;
        this.m_listeners = listeners;
        this.m_id = moduleId;
        this.m_name = name;
        this.m_description = comment;
        this.m_creationDate = new Date(creationDate.getTime());
        this.m_modificationDate = new Date(modificationDate.getTime());
        this.m_md5 = md52;
        this.m_sha1 = sha1;
        this.m_fileBase = fileBase;
        this.m_imageBase = imageBase;
        this.m_debuggerTemplate = debuggerTemplate;
        this.m_isStared = isStared;
        this.m_rawModule = rawModule;
        this.updateDebugger(debuggerTemplate);
    }

    private void updateDebugger(DebuggerTemplate template) {
        if (this.m_debugger == null || !this.m_debugger.isConnected()) {
            if (template == null) {
                this.m_debugger = null;
            } else {
                this.m_debugger = new TcpDebugger(template, new ModuleTargetSettings(this.m_module));
                this.m_debugger.setAddressTranslator(this.m_module, this.m_fileBase, this.m_imageBase);
            }
            for (IModuleListener listener : this.m_listeners) {
                try {
                    listener.changedDebugger(this.m_module, this.m_debugger);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.m_creationDate.getTime());
    }

    @Override
    public IDebugger getDebugger() {
        return this.m_debugger;
    }

    @Override
    public DebuggerTemplate getDebuggerTemplate() {
        return this.m_debuggerTemplate;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public IAddress getFileBase() {
        return this.m_fileBase;
    }

    @Override
    public int getId() {
        return this.m_id;
    }

    @Override
    public IAddress getImageBase() {
        return this.m_imageBase;
    }

    @Override
    public String getMD5() {
        return this.m_md5;
    }

    @Override
    public Date getModificationDate() {
        return new Date(this.m_modificationDate.getTime());
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public INaviRawModule getRawModule() {
        return this.m_rawModule;
    }

    @Override
    public String getSha1() {
        return this.m_sha1;
    }

    @Override
    public boolean isStared() {
        return this.m_isStared;
    }

    @Override
    public void setDebuggerTemplate(DebuggerTemplate template) throws CouldntSaveDataException {
        if (template == this.m_debuggerTemplate) {
            return;
        }
        this.m_provider.assignDebugger(this.m_module, template);
        this.m_debuggerTemplate = template;
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.changedDebuggerTemplate(this.m_module, template);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateDebugger(template);
        this.updateModificationDate();
    }

    @Override
    public void setDescription(String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(description, "IE00199: Description string can not be null");
        if (description.equals(this.m_description)) {
            return;
        }
        this.m_provider.setDescription(this.m_module, description);
        this.m_description = description;
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.changedDescription(this.m_module, description);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    @Override
    public void setFileBase(IAddress fileBase) throws CouldntSaveDataException {
        Preconditions.checkNotNull(fileBase, "IE00200: File base argument can not be null");
        if (fileBase.equals(this.m_fileBase)) {
            return;
        }
        this.m_provider.setFileBase(this.m_module, fileBase);
        this.m_fileBase = fileBase;
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.changedFileBase(this.m_module, fileBase);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    @Override
    public void setImageBase(IAddress imageBase) throws CouldntSaveDataException {
        Preconditions.checkNotNull(imageBase, "IE00201: Image base argument can not be null");
        if (imageBase.equals(this.m_imageBase)) {
            return;
        }
        this.m_provider.setImageBase(this.m_module, imageBase);
        this.m_imageBase = imageBase;
        if (this.m_debugger != null) {
            this.m_debugger.setAddressTranslator(this.m_module, this.m_fileBase, this.m_imageBase);
        }
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.changedImageBase(this.m_module, imageBase);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    @Override
    public void setName(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00202: Name string can not be null");
        if (name.equals(this.m_name)) {
            return;
        }
        this.m_provider.setName(this.m_module, name);
        this.m_name = name;
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.changedName(this.m_module, name);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    @Override
    public void setStared(boolean isStared) throws CouldntSaveDataException {
        if (this.m_isStared == isStared) {
            return;
        }
        this.m_provider.setStared(this.m_module, isStared);
        this.m_isStared = isStared;
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.changedStarState(this.m_module, isStared);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void updateModificationDate() {
        try {
            this.m_modificationDate = this.m_provider.getModificationDate(this.m_module);
            for (IModuleListener listener : this.m_listeners) {
                try {
                    listener.changedModificationDate(this.m_module, this.m_modificationDate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
        catch (CouldntLoadDataException e2) {
            CUtilityFunctions.logException(e2);
        }
    }
}

