/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.Modules;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CFunctionListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IFunction;
import com.google.security.zynamics.zylib.disassembly.IFunctionListener;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CFunctionContainer {
    private final INaviModule m_module;
    private final Map<IAddress, INaviFunction> m_functionMap = new HashMap<IAddress, INaviFunction>();
    private final IFilledList<INaviFunction> m_functions;
    private final IFunctionListener<IComment> m_functionListener = new InternalFunctionListener();

    public CFunctionContainer(INaviModule module, List<INaviFunction> functions) {
        this.m_module = Preconditions.checkNotNull(module, "IE02399: module argument can not be null");
        this.m_functions = new FilledList<INaviFunction>((Collection)Preconditions.checkNotNull(functions, "IE02400: functions argument can not be null"));
        for (INaviFunction function : functions) {
            this.m_functionMap.put(function.getAddress(), function);
        }
        for (INaviFunction function : functions) {
            function.addListener(this.m_functionListener);
        }
    }

    public boolean close() {
        for (INaviFunction function : this.m_functions) {
            if (!function.isLoaded() || !function.close()) continue;
            return false;
        }
        return true;
    }

    public INaviFunction getFunction(IAddress address) {
        Preconditions.checkNotNull(address, "IE00197: Address argument can not be null");
        return this.m_functionMap.get(address);
    }

    public INaviFunction getFunction(String name) throws MaybeNullException {
        Preconditions.checkNotNull(name, "IE00176: Name argument can not be null");
        for (INaviFunction function : this.m_functions) {
            if (!function.getName().equals(name)) continue;
            return function;
        }
        throw new MaybeNullException();
    }

    public int getFunctionCount() {
        return this.m_functions.size();
    }

    public List<INaviFunction> getFunctions() {
        return new ArrayList<INaviFunction>(this.m_functions);
    }

    private class InternalFunctionListener
    extends CFunctionListenerAdapter {
        private InternalFunctionListener() {
        }

        @Override
        public void changedName(IFunction function, String name) {
            INaviView view = CFunctionContainer.this.m_module.getContent().getViewContainer().getView((INaviFunction)function);
            try {
                view.getConfiguration().setName(name);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }
}

