/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.CommentListener;
import com.google.security.zynamics.binnavi.disassembly.CommentListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNodeListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.Color;
import java.util.List;
import java.util.Set;

public final class CTextNode
extends CNaviViewNode
implements INaviTextNode {
    private final SQLProvider m_provider;
    private final ListenerProvider<INaviTextNodeListener> m_listeners = new ListenerProvider();
    private final CommentListener m_internalCommentListener = new InternalCommentListener();

    public CTextNode(int nodeId, double x2, double y2, double width, double height, Color color, boolean selected, boolean visible, Set<CTag> tags, List<IComment> comments, SQLProvider provider) {
        super(nodeId, x2, y2, width, height, color, color.darker().darker(), selected, visible, tags, provider);
        this.m_provider = Preconditions.checkNotNull(provider, "IE02393: provider argument can not be null");
        CommentManager.get(this.m_provider).initializeTextNodeComment(this, comments);
        CommentManager.get(this.m_provider).addListener(this.m_internalCommentListener);
    }

    @Override
    public void addListener(INaviTextNodeListener listener) {
        super.addListener(listener);
        this.m_listeners.addListener(listener);
    }

    @Override
    public List<IComment> appendComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        return CommentManager.get(this.m_provider).appendTextNodeComment((INaviTextNode)this, commentText);
    }

    @Override
    public CTextNode cloneNode() {
        return new CTextNode(-1, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getColor(), this.isSelected(), this.isVisible(), this.getTags(), this.getComments(), this.m_provider);
    }

    @Override
    public void deleteComment(IComment comment) throws CouldntDeleteException {
        CommentManager.get(this.m_provider).deleteTextNodeComment(this, comment);
    }

    @Override
    public IComment editComment(IComment oldComment, String commentText) throws CouldntSaveDataException {
        return CommentManager.get(this.m_provider).editTextNodeComment(this, oldComment, commentText);
    }

    @Override
    public List<IComment> getComments() {
        return CommentManager.get(this.m_provider).getTextNodeComment(this);
    }

    @Override
    public void initializeComment(List<IComment> comments) {
        CommentManager.get(this.m_provider).initializeTextNodeComment(this, comments);
    }

    @Override
    public boolean isOwner(IComment comment) {
        Preconditions.checkNotNull(comment, "IE02612: comment argument can not be null");
        return CUserManager.get(this.m_provider).getCurrentActiveUser().equals(comment.getUser());
    }

    @Override
    public void removeListener(INaviTextNodeListener listener) {
        super.removeListener(listener);
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void close() {
        super.close();
        CommentManager.get(this.m_provider).unloadTextNodeComment(this, this.getComments());
        CommentManager.get(this.m_provider).removeListener(this.m_internalCommentListener);
    }

    private class InternalCommentListener
    extends CommentListenerAdapter {
        private InternalCommentListener() {
        }

        @Override
        public void appendedTextNodeComment(INaviTextNode node, IComment comment) {
            if (CTextNode.this.equals(node)) {
                for (INaviTextNodeListener listener : CTextNode.this.m_listeners) {
                    try {
                        listener.appendedTextNodeComment(node, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void deletedTextNodeComment(INaviTextNode node, IComment comment) {
            if (CTextNode.this.equals(node)) {
                for (INaviTextNodeListener listener : CTextNode.this.m_listeners) {
                    try {
                        listener.deletedTextNodeComment(node, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedTextNodeComment(INaviTextNode node, IComment comment) {
            if (CTextNode.this.equals(node)) {
                for (INaviTextNodeListener listener : CTextNode.this.m_listeners) {
                    try {
                        listener.editedTextNodeComment(node, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void initializedTextNodeComments(INaviTextNode node, List<IComment> comments) {
            if (CTextNode.this.equals(node)) {
                for (INaviTextNodeListener listener : CTextNode.this.m_listeners) {
                    try {
                        listener.initializedTextNodeComment(node, comments);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }
    }
}

