/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.ProjectTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.trace.ProjectTraceProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceConfigurationListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceContent;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceContentListener;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.CViewFilter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainerListener;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class CProjectContainer
implements IViewContainer {
    private final IDatabase m_database;
    private final INaviProject m_project;
    private final INaviAddressSpace m_addressSpace;
    private final ITraceListProvider m_provider;
    private final ListenerProvider<IViewContainerListener> m_listeners = new ListenerProvider();
    private final InternalListener m_listener = new InternalListener();
    private final InternalAddressSpaceListener m_addressSpaceListener = new InternalAddressSpaceListener();
    private final InternalAddressSpaceConfigurationListener m_addressSpaceConfigurationListener = new InternalAddressSpaceConfigurationListener();
    private final InternalModuleListener m_moduleListener = new InternalModuleListener();
    private final DebuggerProvider m_debuggerProvider;
    private final Map<INaviAddressSpace, IDebugger> m_activeDebuggers = new HashMap<INaviAddressSpace, IDebugger>();
    private final IAddressSpaceContentListener m_internalContentListener = new InternalAddressSpaceContentListener();

    public CProjectContainer(IDatabase database, INaviProject project) {
        this.m_database = Preconditions.checkNotNull(database, "IE01785: database argument can not be null");
        this.m_project = Preconditions.checkNotNull(project, "IE01786: project argument can not be null");
        this.m_addressSpace = null;
        this.m_provider = new ProjectTraceProvider(this.m_project);
        this.m_debuggerProvider = new DebuggerProvider(new ProjectTargetSettings(this.m_project));
        if (this.m_project.isLoaded()) {
            this.updateProjectDebuggers();
        }
        this.m_project.addListener(this.m_listener);
        if (this.m_project.isLoaded()) {
            for (INaviAddressSpace addressSpace : this.m_project.getContent().getAddressSpaces()) {
                this.initializeAddressSpaceListeners(addressSpace);
            }
        }
    }

    public CProjectContainer(IDatabase database, INaviProject project, INaviAddressSpace addressSpace) {
        this.m_database = Preconditions.checkNotNull(database, "IE01788: database argument can not be null");
        this.m_project = Preconditions.checkNotNull(project, "IE01789: project argument can not be null");
        this.m_addressSpace = addressSpace;
        this.m_provider = new ProjectTraceProvider(this.m_project);
        this.m_debuggerProvider = new DebuggerProvider(new ProjectTargetSettings(this.m_project));
        IDebugger debugger = this.m_addressSpace.getConfiguration().getDebugger();
        if (debugger != null) {
            this.m_activeDebuggers.put(addressSpace, debugger);
            this.m_debuggerProvider.addDebugger(debugger);
        }
        this.m_project.addListener(this.m_listener);
        this.initializeAddressSpaceListeners(addressSpace);
    }

    private void initializeAddressSpaceListeners(INaviAddressSpace addressSpace) {
        addressSpace.addListener(this.m_addressSpaceListener);
        addressSpace.getConfiguration().addListener(this.m_addressSpaceConfigurationListener);
        List<INaviModule> allModules = this.getModules();
        if (addressSpace.isLoaded()) {
            addressSpace.getContent().addListener(this.m_internalContentListener);
            for (INaviModule module : addressSpace.getContent().getModules()) {
                if (CollectionHelpers.count(allModules, module) != 1) continue;
                module.addListener(this.m_moduleListener);
            }
        }
    }

    private void initializeModuleListeners(INaviModule module) {
        module.addListener(this.m_moduleListener);
        if (module.isLoaded()) {
            this.notifyModuleViews(module);
        }
    }

    private void notifyModuleViews(INaviModule module) {
        for (INaviView view : module.getContent().getViewContainer().getViews()) {
            for (IViewContainerListener listener : this.m_listeners) {
                try {
                    listener.addedView(this, view);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }

    private void removeAddressSpaceListeners(INaviAddressSpace addressSpace) {
        if (addressSpace.isLoaded()) {
            for (INaviModule module : addressSpace.getContent().getModules()) {
                module.removeListener(this.m_moduleListener);
            }
        }
        addressSpace.removeListener(this.m_addressSpaceListener);
        addressSpace.getConfiguration().removeListener(this.m_addressSpaceConfigurationListener);
    }

    private void removeModuleListeners(INaviModule module) {
        if (module.isLoaded()) {
            for (INaviView view : module.getContent().getViewContainer().getViews()) {
                for (IViewContainerListener listener : this.m_listeners) {
                    try {
                        listener.deletedView(this, view);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }
        module.removeListener(this.m_moduleListener);
    }

    private void updateProjectDebuggers() {
        for (INaviAddressSpace addressSpace : this.m_project.getContent().getAddressSpaces()) {
            IDebugger debugger = addressSpace.getConfiguration().getDebugger();
            if (debugger == null) continue;
            this.m_activeDebuggers.put(addressSpace, debugger);
            this.m_debuggerProvider.addDebugger(debugger);
        }
    }

    @Override
    public Object getNative() {
        return this.m_project;
    }

    @Override
    public void addListener(IViewContainerListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public boolean containsModule(INaviModule module) {
        Preconditions.checkNotNull(module, "IE02213: Module argument can not be null");
        if (this.m_project.isLoaded()) {
            for (INaviAddressSpace addressSpace : this.m_project.getContent().getAddressSpaces()) {
                for (INaviModule m2 : addressSpace.getContent().getModules()) {
                    if (module != m2) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public INaviView createView(String name, String description) {
        Preconditions.checkNotNull(name, "IE02214: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE02215: Description argument can not be null");
        return this.m_project.getContent().createView(name, description);
    }

    @Override
    public void deleteView(INaviView view) throws CouldntDeleteException {
        Preconditions.checkNotNull(view, "IE02216: View argument can not be null");
        this.m_project.getContent().deleteView(view);
    }

    @Override
    public void dispose() {
        this.m_project.removeListener(this.m_listener);
        if (this.m_addressSpace != null) {
            this.m_addressSpace.removeListener(this.m_addressSpaceListener);
            this.m_addressSpace.getConfiguration().removeListener(this.m_addressSpaceConfigurationListener);
        }
    }

    @Override
    public List<INaviAddressSpace> getAddressSpaces() {
        return this.m_project.getContent().getAddressSpaces();
    }

    @Override
    public IDatabase getDatabase() {
        return this.m_database;
    }

    @Override
    public DebuggerProvider getDebuggerProvider() {
        return this.m_debuggerProvider;
    }

    @Override
    public INaviFunction getFunction(INaviView view) {
        Preconditions.checkNotNull(view, "IE02217: View argument can not be null");
        for (INaviAddressSpace addressSpace : this.m_project.getContent().getAddressSpaces()) {
            if (!addressSpace.isLoaded()) continue;
            for (INaviModule module : addressSpace.getContent().getModules()) {
                INaviFunction function;
                if (!module.isLoaded() || (function = module.getContent().getViewContainer().getFunction(view)) == null) continue;
                return function;
            }
        }
        return null;
    }

    @Override
    public List<INaviFunction> getFunctions() {
        return new ArrayList<INaviFunction>();
    }

    @Override
    public List<INaviModule> getModules() {
        HashSet<INaviModule> modules = new HashSet<INaviModule>();
        for (INaviAddressSpace addressSpace : this.m_project.getContent().getAddressSpaces()) {
            if (!addressSpace.isLoaded()) continue;
            for (INaviModule naviModule : addressSpace.getContent().getModules()) {
                modules.add(naviModule);
            }
        }
        return new FilledList<INaviModule>((Collection<INaviModule>)modules);
    }

    @Override
    public String getName() {
        return this.m_project.getConfiguration().getName();
    }

    @Override
    public List<Pair<INaviView, CTag>> getTaggedViews() {
        return CViewFilter.getTaggedViews(this.m_project.getContent().getViews());
    }

    @Override
    public List<INaviView> getTaggedViews(CTag object) {
        return CViewFilter.getTaggedViews(this.m_project.getContent().getViews(), object);
    }

    @Override
    public ITraceListProvider getTraceProvider() {
        return this.m_provider;
    }

    @Override
    public List<INaviView> getUserViews() {
        return this.m_project.getContent().getViews();
    }

    @Override
    public INaviView getView(INaviFunction function) {
        Preconditions.checkNotNull(function, "IE02218: Function argument can not be null");
        for (INaviView view : this.getViews()) {
            if (this.getFunction(view) != function) continue;
            return view;
        }
        return null;
    }

    @Override
    public int getViewCount() {
        return this.m_project.getContent().getViews().size();
    }

    @Override
    public List<INaviView> getViews() {
        HashSet<INaviView> views = new HashSet<INaviView>();
        if (this.m_project.isLoaded()) {
            for (INaviAddressSpace addressSpace : this.m_project.getContent().getAddressSpaces()) {
                if (!addressSpace.isLoaded()) continue;
                for (INaviModule module : addressSpace.getContent().getModules()) {
                    if (!module.isLoaded()) continue;
                    views.addAll(module.getContent().getViewContainer().getViews());
                }
            }
        }
        if (this.m_project.isLoaded()) {
            views.addAll(this.m_project.getContent().getViews());
        }
        return new ArrayList<INaviView>(views);
    }

    @Override
    public List<INaviView> getViewsWithAddresses(List<UnrelocatedAddress> addresses, boolean all) throws CouldntLoadDataException {
        Preconditions.checkNotNull(addresses, "IE02219: Addresses argument can not be null");
        return this.m_project.getViewsWithAddresses(addresses, all);
    }

    @Override
    public boolean isLoaded() {
        return this.m_project.isLoaded();
    }

    @Override
    public void removeListener(IViewContainerListener listener) {
        Preconditions.checkNotNull(listener, "IE02220: Listener argument can not be null");
        this.m_listeners.removeListener(listener);
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void addedView(INaviModule module, INaviView view) {
            for (IViewContainerListener listener : CProjectContainer.this.m_listeners) {
                try {
                    listener.addedView(CProjectContainer.this, view);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedView(INaviModule module, INaviView view) {
            for (IViewContainerListener listener : CProjectContainer.this.m_listeners) {
                try {
                    listener.deletedView(CProjectContainer.this, view);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void loadedModule(INaviModule module) {
            Preconditions.checkNotNull(module, "IE02221: Module argument can not be null");
            CProjectContainer.this.notifyModuleViews(module);
        }
    }

    private class InternalListener
    extends CProjectListenerAdapter {
        private InternalListener() {
        }

        @Override
        public void addedAddressSpace(INaviProject project, CAddressSpace space) {
            CProjectContainer.this.initializeAddressSpaceListeners(space);
        }

        @Override
        public void addedView(INaviProject module, INaviView view) {
            for (IViewContainerListener listener : CProjectContainer.this.m_listeners) {
                try {
                    listener.addedView(CProjectContainer.this, view);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedView(INaviProject module, INaviView view) {
            for (IViewContainerListener listener : CProjectContainer.this.m_listeners) {
                try {
                    listener.deletedView(CProjectContainer.this, view);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void loadedProject(CProject project) {
            for (INaviAddressSpace addressSpace : CProjectContainer.this.m_project.getContent().getAddressSpaces()) {
                CProjectContainer.this.initializeAddressSpaceListeners(addressSpace);
            }
            CProjectContainer.this.updateProjectDebuggers();
            for (IViewContainerListener listener : CProjectContainer.this.m_listeners) {
                try {
                    listener.loaded(CProjectContainer.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedAddressSpace(INaviProject project, INaviAddressSpace addressSpace) {
            CProjectContainer.this.removeAddressSpaceListeners(addressSpace);
        }
    }

    private class InternalAddressSpaceListener
    extends CAddressSpaceListenerAdapter {
        private InternalAddressSpaceListener() {
        }

        @Override
        public void closed(INaviAddressSpace addressSpace, CAddressSpaceContent content) {
            content.removeListener(CProjectContainer.this.m_internalContentListener);
        }

        @Override
        public void loaded(INaviAddressSpace addressSpace) {
            addressSpace.getContent().addListener(CProjectContainer.this.m_internalContentListener);
            List<INaviModule> modules = addressSpace.getContent().getModules();
            List<INaviModule> allModules = CProjectContainer.this.getModules();
            for (INaviModule module : modules) {
                if (CollectionHelpers.count(allModules, module) != 1) continue;
                CProjectContainer.this.initializeModuleListeners(module);
            }
        }
    }

    private class InternalAddressSpaceContentListener
    implements IAddressSpaceContentListener {
        private InternalAddressSpaceContentListener() {
        }

        @Override
        public void addedModule(INaviAddressSpace addressSpace, INaviModule module) {
            List<INaviModule> modules = CProjectContainer.this.getModules();
            if (CollectionHelpers.count(modules, module) == 1) {
                CProjectContainer.this.initializeModuleListeners(module);
            }
        }

        @Override
        public void changedImageBase(INaviAddressSpace addressSpace, INaviModule module, IAddress address) {
        }

        @Override
        public void removedModule(INaviAddressSpace addressSpace, INaviModule module) {
            CProjectContainer.this.removeModuleListeners(module);
        }
    }

    private class InternalAddressSpaceConfigurationListener
    extends CAddressSpaceConfigurationListenerAdapter {
        private InternalAddressSpaceConfigurationListener() {
        }

        @Override
        public void changedDebugger(INaviAddressSpace addressSpace, DebuggerTemplate debugger) {
            IDebugger previousDebugger = (IDebugger)CProjectContainer.this.m_activeDebuggers.get(addressSpace);
            if (previousDebugger != null) {
                CProjectContainer.this.m_debuggerProvider.removeDebugger(previousDebugger);
                CProjectContainer.this.m_activeDebuggers.remove(addressSpace);
            }
            if (debugger != null) {
                CProjectContainer.this.m_debuggerProvider.addDebugger(addressSpace.getConfiguration().getDebugger());
                CProjectContainer.this.m_activeDebuggers.put(addressSpace, addressSpace.getConfiguration().getDebugger());
            }
        }
    }
}

