/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.CProjectConfiguration;
import com.google.security.zynamics.binnavi.disassembly.CProjectContent;
import com.google.security.zynamics.binnavi.disassembly.CProjectLoaderReporter;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.IProjectListener;
import com.google.security.zynamics.binnavi.disassembly.ProjectLoadEvents;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public final class CProject
implements INaviProject {
    private final SQLProvider m_provider;
    private final ListenerProvider<IProjectListener> m_listeners = new ListenerProvider();
    private final int m_addressSpaceCount;
    private final CProjectConfiguration m_configuration;
    private CProjectContent m_content = null;
    private boolean m_isLoading = false;
    private final CProjectLoaderReporter m_loadReporter = new CProjectLoaderReporter(this.m_listeners);

    public CProject(int projectId, String name, String description, Date creationDate, Date modificationDate, int addressSpaceCount, List<DebuggerTemplate> assignedDebuggers, SQLProvider provider) {
        Preconditions.checkArgument(projectId > 0, String.format("IE00226: Project ID %d is invalid. Project IDs must be strictly positive", projectId));
        Preconditions.checkNotNull(name, "IE00227: Project names can't be null");
        Preconditions.checkNotNull(description, "IE00228: Project descriptions can't be null");
        Preconditions.checkNotNull(creationDate, "IE00229: Project creation dates can't be null");
        Preconditions.checkNotNull(modificationDate, "IE00230: Project modification dates can't be null");
        Preconditions.checkNotNull(provider, "IE00231: The SQL provider of the project can't be null");
        this.m_configuration = new CProjectConfiguration(this, this.m_listeners, provider, projectId, name, description, creationDate, modificationDate, assignedDebuggers);
        this.m_addressSpaceCount = addressSpaceCount;
        this.m_provider = provider;
    }

    @Override
    public void addListener(IProjectListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public boolean close() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("IE00239: Project is not loaded");
        }
        for (IProjectListener listener : this.m_listeners) {
            try {
                if (listener.closingProject(this)) continue;
                return false;
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_content.close();
        this.m_content = null;
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.closedProject(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return true;
    }

    @Override
    public int getAddressSpaceCount() {
        return this.isLoaded() ? this.m_content.getAddressSpaces().size() : this.m_addressSpaceCount;
    }

    @Override
    public CProjectConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public CProjectContent getContent() {
        Preconditions.checkNotNull(this.m_content, "IE02198: Project is not loaded");
        return this.m_content;
    }

    @Override
    public List<INaviView> getViewsWithAddresses(List<UnrelocatedAddress> offset, boolean all) throws CouldntLoadDataException {
        return this.m_provider.getViewsWithAddress(this, offset, all);
    }

    public boolean hasDebugger(DebuggerTemplate debugger) {
        return this.m_configuration.hasDebugger(debugger);
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject object) {
        Preconditions.checkNotNull(object, "IE00250: Object argument can't be null");
        return object.inSameDatabase(this.m_provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return provider.equals(this.m_provider);
    }

    @Override
    public boolean isLoaded() {
        return this.m_content != null;
    }

    @Override
    public boolean isLoading() {
        return this.m_isLoading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws CouldntLoadDataException, LoadCancelledException {
        CProjectLoaderReporter cProjectLoaderReporter = this.m_loadReporter;
        synchronized (cProjectLoaderReporter) {
            if (this.isLoaded()) {
                return;
            }
            this.m_isLoading = true;
            try {
                if (!this.m_loadReporter.report(ProjectLoadEvents.Starting)) {
                    throw new LoadCancelledException();
                }
                if (!this.m_loadReporter.report(ProjectLoadEvents.LoadingAddressSpaces)) {
                    throw new LoadCancelledException();
                }
                List<CAddressSpace> addressSpaces = this.m_provider.loadAddressSpaces(this);
                for (CAddressSpace space : addressSpaces) {
                    space.load();
                }
                if (!this.m_loadReporter.report(ProjectLoadEvents.LoadingCallgraphViews)) {
                    throw new LoadCancelledException();
                }
                List<ICallgraphView> userCallgraphs = this.m_provider.loadCallgraphViews(this);
                if (!this.m_loadReporter.report(ProjectLoadEvents.LoadingFlowgraphViews)) {
                    throw new LoadCancelledException();
                }
                List<IFlowgraphView> userFlowgraphs = this.m_provider.loadFlowgraphs(this);
                if (!this.m_loadReporter.report(ProjectLoadEvents.LoadingMixedgraphViews)) {
                    throw new LoadCancelledException();
                }
                List<INaviView> userMixedgraphs = this.m_provider.loadMixedgraphs(this);
                if (!this.m_loadReporter.report(ProjectLoadEvents.LoadingTraces)) {
                    throw new LoadCancelledException();
                }
                List<TraceList> traces = this.m_provider.loadTraces(this);
                ArrayList<INaviView> views = new ArrayList<INaviView>(userCallgraphs);
                views.addAll(userFlowgraphs);
                views.addAll(userMixedgraphs);
                this.m_content = new CProjectContent(this, this.m_listeners, this.m_provider, addressSpaces, views, new FilledList<TraceList>((Collection<TraceList>)traces));
            }
            catch (CouldntLoadDataException | LoadCancelledException e2) {
                this.m_isLoading = false;
                throw e2;
            }
            finally {
                this.m_loadReporter.report(ProjectLoadEvents.Finished);
            }
            for (IProjectListener listener : this.m_listeners) {
                try {
                    listener.loadedProject(this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            this.m_isLoading = false;
        }
    }

    @Override
    public String readSetting(String key) throws CouldntLoadDataException {
        return this.m_provider.readSetting(this, key);
    }

    @Override
    public void removeListener(IProjectListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void writeSetting(String key, String value) throws CouldntSaveDataException {
        this.m_provider.writeSetting(this, key, value);
    }
}

