/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTree;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.disassembly.IReference;
import com.google.security.zynamics.zylib.strings.Commafier;
import java.util.ArrayList;
import java.util.List;

public final class COperandTree
implements INaviOperandTree {
    private final COperandTreeNode root;
    private final SQLProvider provider;
    private INaviInstruction instruction;
    private final TypeManager typeManager;
    private final TypeInstanceContainer instanceContainer;

    public COperandTree(COperandTreeNode rootNode, SQLProvider provider, TypeManager typeManager, TypeInstanceContainer instanceContainer) {
        Preconditions.checkNotNull(rootNode, "IE00212: Root node can't be null.");
        this.typeManager = Preconditions.checkNotNull(typeManager, "Type manager can not be null.");
        this.instanceContainer = Preconditions.checkNotNull(instanceContainer, "Type instance container can not be null.");
        this.provider = Preconditions.checkNotNull(provider, "Sql provider can not be null.");
        if (rootNode.getChildren().size() == 0) {
            COperandTreeNode realParent = new COperandTreeNode(-1, 6, "b4", null, new ArrayList<IReference>(), provider, typeManager, instanceContainer);
            COperandTreeNode.link(realParent, rootNode);
            this.root = realParent;
        } else {
            this.root = rootNode;
        }
        this.initializeTree(this.root);
    }

    private static void collect(INaviOperandTreeNode currentNode, List<INaviOperandTreeNode> nodes) {
        nodes.add(currentNode);
        for (INaviOperandTreeNode child : currentNode.getChildren()) {
            COperandTree.collect(child, nodes);
        }
    }

    private void initializeTree(COperandTreeNode node) {
        node.setOperand(this);
        for (IOperandTreeNode iOperandTreeNode : node.getChildren()) {
            this.initializeTree((COperandTreeNode)iOperandTreeNode);
        }
    }

    private String toString(IOperandTreeNode node) {
        ArrayList<String> flattenedChildren = new ArrayList<String>();
        for (IOperandTreeNode iOperandTreeNode : node.getChildren()) {
            flattenedChildren.add(this.toString(iOperandTreeNode));
        }
        if (flattenedChildren.isEmpty()) {
            return node.toString();
        }
        if (flattenedChildren.size() == 1) {
            ExpressionType type = node.getType();
            if (type == ExpressionType.MEMDEREF) {
                String string2 = (String)flattenedChildren.get(0);
                return new StringBuilder(2 + String.valueOf(string2).length()).append("[").append(string2).append("]").toString();
            }
            if (type == ExpressionType.EXPRESSION_LIST) {
                String string3 = String.valueOf(Commafier.commafy(flattenedChildren));
                return new StringBuilder(2 + String.valueOf(string3).length()).append("{").append(string3).append("}").toString();
            }
            String string4 = String.valueOf(node.toString());
            String string5 = node.toString().isEmpty() ? "" : " ";
            String string6 = (String)flattenedChildren.get(0);
            return new StringBuilder(0 + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string4).append(string5).append(string6).toString();
        }
        String value = node.toString();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < flattenedChildren.size(); ++i2) {
            stringBuffer.append((String)flattenedChildren.get(i2));
            if (i2 == flattenedChildren.size() - 1) continue;
            stringBuffer.append(' ');
            stringBuffer.append(value);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    protected void setNaviInstruction(INaviInstruction instruction) {
        Preconditions.checkArgument(this.instruction == null, "IE00213: Instruction already initialized");
        this.instruction = instruction;
    }

    public COperandTree cloneTree() {
        return new COperandTree(this.root.cloneNode(), this.provider, this.typeManager, this.instanceContainer);
    }

    public void close() {
        for (INaviOperandTreeNode node : this.getNodes()) {
            node.close();
        }
    }

    @Override
    public INaviInstruction getInstruction() {
        return this.instruction;
    }

    public List<INaviOperandTreeNode> getNodes() {
        ArrayList<INaviOperandTreeNode> nodes = new ArrayList<INaviOperandTreeNode>();
        COperandTree.collect(this.root, nodes);
        return nodes;
    }

    @Override
    public COperandTreeNode getRootNode() {
        return this.root;
    }

    public String toString() {
        return this.toString(this.root);
    }
}

