/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.IBlockEdge;
import com.google.security.zynamics.binnavi.disassembly.IBlockNode;
import com.google.security.zynamics.binnavi.disassembly.INaviBasicBlock;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CInliningResult;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.disassembly.IReference;
import com.google.security.zynamics.zylib.disassembly.ReferenceType;
import com.google.security.zynamics.zylib.general.Triple;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.types.graphs.DirectedGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.grouping.GroupHelpers;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CInliningHelper {
    private CInliningHelper() {
    }

    private static void createEdges(INaviView view, List<IBlockEdge> edges, Map<IBlockNode, CCodeNode> map) {
        for (IBlockEdge edge : edges) {
            CCodeNode sourceNode = map.get(edge.getSource());
            CCodeNode targetNode = map.get(edge.getTarget());
            view.getContent().createEdge(sourceNode, targetNode, edge.getType());
        }
    }

    private static void createNode(INaviView view, INaviFunction function, IBlockNode blockNode, Map<IBlockNode, CCodeNode> map, INaviGroupNode parentGroup) {
        ArrayList<INaviInstruction> instructions = new ArrayList<INaviInstruction>();
        ArrayList<CCodeNode> createNodes = new ArrayList<CCodeNode>();
        INaviBasicBlock block = blockNode.getBlock();
        for (INaviInstruction instruction : block) {
            instructions.add(instruction.cloneInstruction());
        }
        if (!instructions.isEmpty()) {
            CCodeNode node = view.getContent().createCodeNode(function, instructions);
            node.setColor(new Color(221, 234, 244));
            if (node.getAddress().equals(function.getAddress()) && blockNode.getChildren().size() == 0) {
                node.setBorderColor(new Color(-6250496));
            } else if (node.getAddress().equals(function.getAddress())) {
                node.setBorderColor(new Color(-16736256));
            } else if (blockNode.getChildren().size() == 0) {
                node.setBorderColor(new Color(-6291456));
            }
            if (parentGroup != null) {
                parentGroup.addElement(node);
            }
            createNodes.add(node);
            map.put(blockNode, node);
        }
    }

    private static Map<IBlockNode, CCodeNode> createNodes(INaviView view, INaviFunction function, INaviGroupNode parentGroup) {
        LinkedHashMap<IBlockNode, CCodeNode> map = new LinkedHashMap<IBlockNode, CCodeNode>();
        for (IBlockNode blockNode : function.getBasicBlocks()) {
            CInliningHelper.createNode(view, function, blockNode, map, parentGroup);
        }
        return map;
    }

    private static void getCodeReference(IOperandTreeNode node, List<IReference> references) {
        List<IReference> nodeReferences = node.getReferences();
        for (IReference iReference : nodeReferences) {
            if (iReference == null || !ReferenceType.isCodeReference(iReference.getType())) continue;
            references.add(iReference);
            break;
        }
        for (IOperandTreeNode iOperandTreeNode : node.getChildren()) {
            CInliningHelper.getCodeReference(iOperandTreeNode, references);
        }
    }

    private static List<IReference> getCodeReferences(INaviInstruction instruction) {
        ArrayList<IReference> references = new ArrayList<IReference>();
        for (IOperandTree iOperandTree : instruction.getOperands()) {
            CInliningHelper.getCodeReference(iOperandTree.getRootNode(), references);
        }
        return references;
    }

    private static Triple<CCodeNode, List<CCodeNode>, ArrayList<CCodeNode>> getRelevantNodes(INaviFunction function, ArrayList<CCodeNode> nodes) {
        ArrayList<CCodeNode> exitNodes = new ArrayList<CCodeNode>();
        CCodeNode entryNode = null;
        for (CCodeNode node : nodes) {
            if (node.getOutgoingEdges().isEmpty()) {
                exitNodes.add(node);
            }
            if (!node.getAddress().equals(function.getAddress())) continue;
            entryNode = node;
        }
        return new Triple(entryNode, exitNodes, nodes);
    }

    private static List<INaviViewNode> getTargetNode(IReference reference, List<INaviViewNode> graphNodes) {
        ArrayList<INaviViewNode> nodes = new ArrayList<INaviViewNode>();
        for (INaviViewNode node : graphNodes) {
            INaviFunctionNode fnode;
            if (!(node instanceof INaviFunctionNode) || !(fnode = (INaviFunctionNode)node).getFunction().getAddress().equals(reference.getTarget())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private static Triple<CCodeNode, List<CCodeNode>, ArrayList<CCodeNode>> insertNodes(INaviView view, INaviFunction function, INaviGroupNode parentGroup) {
        DirectedGraph<IBlockNode, IBlockEdge> graph = function.getGraph();
        Map<IBlockNode, CCodeNode> map = CInliningHelper.createNodes(view, function, parentGroup);
        CInliningHelper.createEdges(view, graph.getEdges(), map);
        return CInliningHelper.getRelevantNodes(function, Lists.newArrayList(map.values()));
    }

    public static CInliningResult inlineCodeNode(INaviView view, INaviCodeNode originalNode, INaviInstruction inlineInstruction, INaviFunction functionToInline) {
        INaviCodeNode firstNode;
        Preconditions.checkNotNull(view, "IE00108: View argument can not be null");
        Preconditions.checkNotNull(originalNode, "IE00109: Node argument can not be null");
        Preconditions.checkNotNull(inlineInstruction, "IE00110: Instruction argument can not be null");
        Preconditions.checkArgument(originalNode.hasInstruction(inlineInstruction), "IE00111: Instruction is not part of the code node");
        Preconditions.checkNotNull(functionToInline, "IE00112: Function argument can not be null");
        Preconditions.checkArgument(view.isLoaded(), "IE00113: View must be loaded before it can be inlined");
        Preconditions.checkArgument(view.getGraph().getNodes().contains(originalNode), "IE00114: Code node does not belong to the view");
        Preconditions.checkArgument(functionToInline.isLoaded(), "IE00115: Function must be loaded before it can be inlined");
        Preconditions.checkArgument(functionToInline.getBasicBlockCount() != 0, "IE00116: Functions with 0 blocks can not be inlined");
        INaviGroupNode parentGroup = originalNode.getParentGroup();
        GroupHelpers.expandParents(originalNode);
        List<INaviEdge> oldIncomingEdges = originalNode.getIncomingEdges();
        List<INaviEdge> oldOutgoingEdges = originalNode.getOutgoingEdges();
        ArrayList<INaviInstruction> upperInstructions = new ArrayList<INaviInstruction>();
        ArrayList lowerInstructions = new ArrayList();
        ArrayList<INaviInstruction> currentBlock = upperInstructions;
        for (INaviInstruction currentInstruction : originalNode.getInstructions()) {
            currentBlock.add(currentInstruction);
            if (currentInstruction != inlineInstruction) continue;
            currentBlock = lowerInstructions;
        }
        ArrayList<Object> continueNodes = new ArrayList<Object>();
        boolean keepOriginalBlock = lowerInstructions.isEmpty();
        CCodeNode returnNode = null;
        if (keepOriginalBlock) {
            firstNode = originalNode;
            for (INaviEdge edge : originalNode.getOutgoingEdges()) {
                continueNodes.add(edge.getTarget());
                view.getContent().deleteEdge(edge);
            }
        } else {
            boolean recolor = originalNode.getIncomingEdges().size() == 1 && originalNode.getIncomingEdges().get(0).getType() == EdgeType.ENTER_INLINED_FUNCTION && originalNode.getOutgoingEdges().size() == 1 && originalNode.getOutgoingEdges().get(0).getType() == EdgeType.LEAVE_INLINED_FUNCTION;
            view.getContent().deleteNode(originalNode);
            try {
                firstNode = view.getContent().createCodeNode(originalNode.getParentFunction(), upperInstructions);
            }
            catch (MaybeNullException exception) {
                firstNode = view.getContent().createCodeNode(null, upperInstructions);
            }
            firstNode.setColor(originalNode.getColor());
            firstNode.setBorderColor(originalNode.getBorderColor());
            try {
                returnNode = view.getContent().createCodeNode(originalNode.getParentFunction(), lowerInstructions);
            }
            catch (MaybeNullException e1) {
                returnNode = view.getContent().createCodeNode(null, lowerInstructions);
            }
            returnNode.setColor(originalNode.getColor());
            if (recolor) {
                firstNode.setBorderColor(new Color(-16736256));
                returnNode.setBorderColor(new Color(-6291456));
            }
            if (parentGroup != null) {
                parentGroup.addElement(firstNode);
                parentGroup.addElement(returnNode);
            }
            Iterator<CTag> it = originalNode.getTagsIterator();
            while (it.hasNext()) {
                CTag tag = it.next();
                try {
                    firstNode.tagNode(tag);
                    returnNode.tagNode(tag);
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
            continueNodes.add(returnNode);
        }
        Triple<CCodeNode, List<CCodeNode>, ArrayList<CCodeNode>> nodes = CInliningHelper.insertNodes(view, functionToInline, parentGroup);
        INaviCodeNode entryNode = nodes.first();
        List<CCodeNode> exitNodes = nodes.second();
        if (!keepOriginalBlock) {
            for (INaviEdge iNaviEdge : oldIncomingEdges) {
                EdgeType edgeType;
                if (iNaviEdge.getSource() == originalNode) {
                    edgeType = iNaviEdge.getType();
                    view.getContent().createEdge(returnNode, firstNode, edgeType);
                    continue;
                }
                edgeType = iNaviEdge.getType();
                view.getContent().createEdge((INaviViewNode)iNaviEdge.getSource(), firstNode, edgeType);
            }
        }
        view.getContent().createEdge(firstNode, entryNode, EdgeType.ENTER_INLINED_FUNCTION);
        for (INaviCodeNode iNaviCodeNode : exitNodes) {
            for (INaviViewNode iNaviViewNode : continueNodes) {
                view.getContent().createEdge(iNaviCodeNode, iNaviViewNode, EdgeType.LEAVE_INLINED_FUNCTION);
            }
        }
        if (!keepOriginalBlock) {
            for (INaviEdge iNaviEdge : oldOutgoingEdges) {
                for (INaviViewNode iNaviViewNode : continueNodes) {
                    if (iNaviEdge.getTarget() == originalNode) continue;
                    view.getContent().createEdge(iNaviViewNode, (INaviViewNode)iNaviEdge.getTarget(), iNaviEdge.getType());
                }
            }
        }
        return new CInliningResult(firstNode, returnNode);
    }

    public static void inlineFunctionNode(INaviView view, INaviFunctionNode node) {
        Preconditions.checkNotNull(view, "IE00119: View argument can not be null");
        Preconditions.checkNotNull(node, "IE00120: Node argument can not be null");
        Preconditions.checkArgument(view.isLoaded(), "IE00122: View must be loaded before it can be inlined");
        Preconditions.checkArgument(view.getGraph().getNodes().contains(node), "IE00123: Code node does not belong to the view");
        Preconditions.checkArgument(node.getFunction().isLoaded(), "IE00124: Function must be loaded before it can be inlined");
        Preconditions.checkArgument(node.getFunction().getBasicBlockCount() != 0, "IE00125: Functions with 0 blocks can not be inlined");
        GroupHelpers.expandParents(node);
        INaviGroupNode parentGroup = node.getParentGroup();
        List<INaviEdge> oldIncomingEdges = node.getIncomingEdges();
        view.getContent().deleteNode(node);
        Triple<CCodeNode, List<CCodeNode>, ArrayList<CCodeNode>> nodes = CInliningHelper.insertNodes(view, node.getFunction(), parentGroup);
        INaviCodeNode entryNode = nodes.first();
        ArrayList<CCodeNode> returnNodes = nodes.third();
        for (INaviEdge incomingEdge : oldIncomingEdges) {
            EdgeType edgeType = incomingEdge.getType();
            view.getContent().createEdge((INaviViewNode)incomingEdge.getSource(), entryNode, edgeType);
        }
        List<INaviViewNode> graphNodes = view.getGraph().getNodes();
        for (INaviCodeNode iNaviCodeNode : returnNodes) {
            iNaviCodeNode.setX(node.getX());
            iNaviCodeNode.setY(node.getY());
            for (INaviInstruction instruction : iNaviCodeNode.getInstructions()) {
                List<IReference> references = CInliningHelper.getCodeReferences(instruction);
                for (IReference reference : references) {
                    List<INaviViewNode> targetNodes = CInliningHelper.getTargetNode(reference, graphNodes);
                    for (INaviViewNode targetNode : targetNodes) {
                        view.getContent().createEdge(iNaviCodeNode, targetNode, EdgeType.JUMP_UNCONDITIONAL);
                    }
                }
            }
        }
    }
}

