/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.CommentListener;
import com.google.security.zynamics.binnavi.disassembly.CommentListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNodeListener;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CGroupNode
extends CNaviViewNode
implements INaviGroupNode {
    private final ListenerProvider<INaviGroupNodeListener> m_listeners = new ListenerProvider();
    private boolean m_collapsed;
    private final SQLProvider m_provider;
    private final List<INaviViewNode> m_elements = new ArrayList<INaviViewNode>();
    private final CommentListener m_internalCommentListener = new InternalCommentListener();

    public CGroupNode(int nodeId, double x2, double y2, double width, double height, Color color, boolean selected, boolean visible, Set<CTag> tags, List<IComment> comment, boolean collapsed, SQLProvider provider) {
        super(nodeId, x2, y2, width, height, color, color.darker().darker(), selected, visible, tags, provider);
        this.m_collapsed = collapsed;
        this.m_provider = Preconditions.checkNotNull(provider, "IE02535: provider argument can not be null");
        CommentManager.get(this.m_provider).initializeGroupNodeComment(this, comment == null ? Lists.newArrayList() : comment);
        CommentManager.get(this.m_provider).addListener(this.m_internalCommentListener);
    }

    @Override
    public void addElement(INaviViewNode node) {
        Preconditions.checkNotNull(node, "IE00107: Node argument can not be null");
        Preconditions.checkArgument(!this.m_elements.contains(node), "IE00102: Can not add node more than once");
        Preconditions.checkArgument(node.getParentGroup() == null, "IE00103: Node already belongs to a group");
        this.m_elements.add(node);
        node.setParentGroup(this);
        for (INaviGroupNodeListener listener : this.m_listeners) {
            try {
                listener.addedElement(this, node);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void addGroupListener(INaviGroupNodeListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public List<IComment> appendComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        return CommentManager.get(this.m_provider).appendGroupNodeComment((INaviGroupNode)this, commentText);
    }

    @Override
    public CGroupNode cloneNode() {
        return new CGroupNode(-1, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getColor(), this.isSelected(), this.isVisible(), this.getTags(), this.getComments(), this.isCollapsed(), this.m_provider);
    }

    @Override
    public void deleteComment(IComment comment) throws CouldntDeleteException {
        CommentManager.get(this.m_provider).deleteGroupNodeComment(this, comment);
    }

    @Override
    public IComment editComment(IComment oldComment, String newComment) throws CouldntSaveDataException {
        return CommentManager.get(this.m_provider).editGroupNodeComment(this, oldComment, newComment);
    }

    @Override
    public List<INaviViewNode> getChildren() {
        HashSet<INaviViewNode> children = new HashSet<INaviViewNode>();
        for (INaviViewNode element : this.m_elements) {
            List<INaviViewNode> outsideChildren = CollectionHelpers.filter(element.getChildren(), new ICollectionFilter<INaviViewNode>(){

                @Override
                public boolean qualifies(INaviViewNode node) {
                    return node.getParentGroup() != CGroupNode.this;
                }
            });
            children.addAll(outsideChildren);
        }
        return new ArrayList<INaviViewNode>(children);
    }

    @Override
    public List<IComment> getComments() {
        return CommentManager.get(this.m_provider).getGroupNodeComment(this);
    }

    @Override
    public List<INaviViewNode> getElements() {
        return new ArrayList<INaviViewNode>(this.m_elements);
    }

    @Override
    public List<INaviEdge> getIncomingEdges() {
        ArrayList<INaviEdge> edges = new ArrayList<INaviEdge>();
        for (INaviViewNode member : this.m_elements) {
            List<INaviEdge> outsideEdges = CollectionHelpers.filter(member.getIncomingEdges(), new ICollectionFilter<INaviEdge>(){

                @Override
                public boolean qualifies(INaviEdge edge) {
                    return ((INaviViewNode)edge.getSource()).getParentGroup() != CGroupNode.this;
                }
            });
            edges.addAll(outsideEdges);
        }
        return edges;
    }

    @Override
    public int getNumberOfElements() {
        return this.m_elements.size();
    }

    @Override
    public List<INaviEdge> getOutgoingEdges() {
        ArrayList<INaviEdge> edges = new ArrayList<INaviEdge>();
        for (INaviViewNode member : this.m_elements) {
            List<INaviEdge> outsideEdges = CollectionHelpers.filter(member.getOutgoingEdges(), new ICollectionFilter<INaviEdge>(){

                @Override
                public boolean qualifies(INaviEdge edge) {
                    return ((INaviViewNode)edge.getTarget()).getParentGroup() != CGroupNode.this;
                }
            });
            edges.addAll(outsideEdges);
        }
        return edges;
    }

    @Override
    public List<INaviViewNode> getParents() {
        HashSet<INaviViewNode> parents = new HashSet<INaviViewNode>();
        for (INaviViewNode element : this.m_elements) {
            List<INaviViewNode> outsideParents = CollectionHelpers.filter(element.getParents(), new ICollectionFilter<INaviViewNode>(){

                @Override
                public boolean qualifies(INaviViewNode node) {
                    return node.getParentGroup() != CGroupNode.this;
                }
            });
            parents.addAll(outsideParents);
        }
        return new ArrayList<INaviViewNode>(parents);
    }

    @Override
    public void initializeComment(List<IComment> comments) {
        CommentManager.get(this.m_provider).initializeGroupNodeComment(this, comments);
    }

    @Override
    public boolean isCollapsed() {
        return this.m_collapsed;
    }

    @Override
    public boolean isOwner(IComment comment) {
        return CUserManager.get(this.m_provider).isOwner(comment);
    }

    @Override
    public boolean isStored() {
        return super.isStored();
    }

    @Override
    public void removeElement(INaviViewNode node) {
        Preconditions.checkNotNull(node, "IE00104: Node argument can not be null");
        Preconditions.checkArgument(this.m_elements.remove(node), "IE00105: Node is not part of this group");
        node.setParentGroup(null);
        for (INaviGroupNodeListener listener : this.m_listeners) {
            try {
                listener.removedElement(this, node);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void removeGroupListener(INaviGroupNodeListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void setCollapsed(boolean collapsed) {
        if (collapsed == this.m_collapsed) {
            return;
        }
        if (collapsed) {
            for (INaviViewNode node : this.m_elements) {
                node.setVisible(true);
            }
        }
        this.m_collapsed = collapsed;
        for (INaviGroupNodeListener listener : this.m_listeners) {
            try {
                listener.changedState(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        CommentManager.get(this.m_provider).unloadGroupNodeComment(this, this.getComments());
        CommentManager.get(this.m_provider).removeListener(this.m_internalCommentListener);
    }

    private class InternalCommentListener
    extends CommentListenerAdapter {
        private InternalCommentListener() {
        }

        @Override
        public void appendedGroupNodeComment(INaviGroupNode node, IComment comment) {
            if (CGroupNode.this.equals(node)) {
                for (INaviGroupNodeListener listener : CGroupNode.this.m_listeners) {
                    try {
                        listener.appendedGroupNodeComment(node, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void deletedGroupNodeComment(INaviGroupNode node, IComment comment) {
            if (CGroupNode.this.equals(node)) {
                for (INaviGroupNodeListener listener : CGroupNode.this.m_listeners) {
                    try {
                        listener.deletedGroupNodeComment(node, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedGroupNodeComment(INaviGroupNode node, IComment comment) {
            if (CGroupNode.this.equals(node)) {
                for (INaviGroupNodeListener listener : CGroupNode.this.m_listeners) {
                    try {
                        listener.editedGroupNodeComment(node, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void initializedGroupNodeComments(INaviGroupNode node, List<IComment> comments) {
            if (CGroupNode.this.equals(node)) {
                for (INaviGroupNodeListener listener : CGroupNode.this.m_listeners) {
                    try {
                        listener.initializedGroupNodeComment(node, comments);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }
    }
}

