/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CFunctionHelpers;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.disassembly.CBasicBlock;
import com.google.security.zynamics.binnavi.disassembly.CBlockNode;
import com.google.security.zynamics.binnavi.disassembly.CFunctionEdge;
import com.google.security.zynamics.binnavi.disassembly.CommentListener;
import com.google.security.zynamics.binnavi.disassembly.CommentListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.IBlockEdge;
import com.google.security.zynamics.binnavi.disassembly.IBlockNode;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.functions.FunctionManager;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.ICodeEdge;
import com.google.security.zynamics.zylib.disassembly.IFunctionListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.graphs.DirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public final class CFunction
implements INaviFunction {
    private final INaviModule module;
    private final INaviView view;
    private final IAddress address;
    private String name;
    private final String originalName;
    private String description;
    private final FunctionType type;
    private final ListenerProvider<IFunctionListener<IComment>> functionListeners = new ListenerProvider();
    private DirectedGraph<IBlockNode, IBlockEdge> functionGraph;
    private final int indegree;
    private final int outdegree;
    private final int blockCount;
    private final int edgeCount;
    private final SQLProvider provider;
    private IAddress forwardedFunctionAddress;
    private int forwardedFunctionModuleId;
    private final String forwardedFunctionModuleName;
    private final CommentListener commentListener = new InternalCommentListener();
    private BaseType stackFrame;
    private BaseType prototype;

    public CFunction(INaviModule module, INaviView view, IAddress address, String name, String originalName, String description, int indegree, int outdegree, int blockCount, int edgeCount, FunctionType type, String forwardedFunctionModuleName, int forwardedFunctionModuleId, IAddress forwardedFunctionAddress, BaseType stackFrame, BaseType prototype, SQLProvider provider) {
        this.module = Preconditions.checkNotNull(module, "IE00069: Module can not be null");
        this.view = Preconditions.checkNotNull(view, "IE00268: View argument can not be null");
        this.address = Preconditions.checkNotNull(address, "IE00070: Function address can not be null");
        this.name = name;
        this.originalName = Preconditions.checkNotNull(originalName, "IE00642: OriginalName argument can not be null");
        this.description = description;
        Preconditions.checkArgument(indegree >= 0, "IE00643: Indegree argument can not be smaller 0");
        this.indegree = indegree;
        Preconditions.checkArgument(outdegree >= 0, "IE01102: Outdegree argument can not be smaller 0");
        this.outdegree = outdegree;
        Preconditions.checkArgument(edgeCount >= 0, "IE01103: Edge count argument can not be smaller 0");
        this.edgeCount = edgeCount;
        Preconditions.checkArgument(blockCount >= 0, "IE02175: Block count argument can not be smaller 0");
        this.blockCount = blockCount;
        this.type = Preconditions.checkNotNull(type, "IE00073: Function type can not be null");
        this.provider = Preconditions.checkNotNull(provider, "IE00074: SQL provider can not be null");
        this.forwardedFunctionModuleId = forwardedFunctionModuleId;
        this.forwardedFunctionAddress = forwardedFunctionAddress;
        this.forwardedFunctionModuleName = forwardedFunctionModuleName;
        this.stackFrame = stackFrame;
        this.prototype = prototype;
        CommentManager.get(provider).addListener(this.commentListener);
        FunctionManager.get(provider).putFunction(this);
    }

    private DirectedGraph<IBlockNode, IBlockEdge> convert(MutableDirectedGraph<INaviViewNode, INaviEdge> viewGraph) {
        LinkedHashMap<INaviCodeNode, CBlockNode> blockMap = new LinkedHashMap<INaviCodeNode, CBlockNode>();
        FilledList edges = new FilledList();
        for (INaviViewNode viewNode : viewGraph) {
            if (!(viewNode instanceof INaviCodeNode)) continue;
            INaviCodeNode cnode = (INaviCodeNode)viewNode;
            CBasicBlock block = new CBasicBlock(1, "", Lists.newArrayList(cnode.getInstructions()));
            CBlockNode blockNode = new CBlockNode(block);
            blockMap.put(cnode, blockNode);
        }
        for (INaviEdge viewEdge : viewGraph.getEdges()) {
            INaviViewNode source = (INaviViewNode)viewEdge.getSource();
            INaviViewNode target = (INaviViewNode)viewEdge.getTarget();
            edges.add(new CFunctionEdge((IBlockNode)blockMap.get(source), (IBlockNode)blockMap.get(target), viewEdge.getType()));
        }
        return new DirectedGraph<IBlockNode, IBlockEdge>(new ArrayList(blockMap.values()), edges);
    }

    @Override
    public void addListener(IFunctionListener<IComment> listener) {
        this.functionListeners.addListener(listener);
    }

    @Override
    public List<IComment> appendGlobalComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(commentText, "IE02531: comment argument can not be null");
        return CommentManager.get(this.provider).appendGlobalFunctionComment(this, commentText);
    }

    @Override
    public boolean close() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("IE00075: Function is not loaded");
        }
        for (IBlockNode iBlockNode : this.functionGraph.getNodes()) {
            for (INaviInstruction instruction : iBlockNode.getInstructions()) {
                instruction.close();
            }
        }
        this.functionGraph = null;
        for (IFunctionListener iFunctionListener : this.functionListeners) {
            iFunctionListener.closed(this);
        }
        if (this.view.isLoaded() && !CWindowManager.instance().isOpen(this.view)) {
            this.view.close();
        }
        CommentManager.get(this.provider).unloadGlobalFunctionComment(this, this.getGlobalComment());
        CommentManager.get(this.provider).removeListener(this.commentListener);
        return true;
    }

    @Override
    public void deleteGlobalComment(IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(comment, "IE02532: New comment can not be null");
        CommentManager.get(this.provider).deleteGlobalFunctionComment(this, comment);
    }

    @Override
    public IComment editGlobalComment(IComment comment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(comment, "IE02533: comment argument can not be null");
        return CommentManager.get(this.provider).editGlobalFunctionComment(this, comment, commentText);
    }

    @Override
    public IAddress getAddress() {
        return this.address;
    }

    @Override
    public int getBasicBlockCount() {
        return this.isLoaded() ? this.functionGraph.nodeCount() : this.blockCount;
    }

    @Override
    public List<? extends ICodeEdge<?>> getBasicBlockEdges() {
        return this.functionGraph.getEdges();
    }

    @Override
    public List<IBlockNode> getBasicBlocks() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("IE00076: Function must be loaded first");
        }
        return this.functionGraph.getNodes();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getEdgeCount() {
        return this.isLoaded() ? this.functionGraph.edgeCount() : this.edgeCount;
    }

    @Override
    public List<IComment> getGlobalComment() {
        return CommentManager.get(this.provider).getGlobalFunctionComment(this);
    }

    @Override
    public DirectedGraph<IBlockNode, IBlockEdge> getGraph() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("IE00077: Function must be loaded first");
        }
        return this.functionGraph;
    }

    @Override
    public int getIndegree() {
        return this.indegree;
    }

    @Override
    public INaviModule getModule() {
        return this.module;
    }

    @Override
    public String getName() {
        return this.name == null ? this.originalName : this.name;
    }

    @Override
    public String getOriginalModulename() {
        return this.forwardedFunctionModuleName == null ? this.module.getConfiguration().getName() : this.forwardedFunctionModuleName;
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }

    @Override
    public int getOutdegree() {
        return this.outdegree;
    }

    @Override
    public IAddress getForwardedFunctionAddress() {
        return this.forwardedFunctionAddress;
    }

    @Override
    public int getForwardedFunctionModuleId() {
        return this.forwardedFunctionModuleId;
    }

    @Override
    public BaseType getStackFrame() {
        return this.stackFrame;
    }

    @Override
    public BaseType getPrototype() {
        return this.prototype;
    }

    @Override
    public void setPrototype(BaseType prototype) {
        this.prototype = prototype;
    }

    @Override
    public FunctionType getType() {
        return this.type;
    }

    @Override
    public void initializeGlobalComment(ArrayList<IComment> comments) {
        if (comments != null) {
            CommentManager.get(this.provider).initializeGlobalFunctionComment(this, comments);
        }
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject object) {
        Preconditions.checkNotNull(object, "IE00078: Object argument can not be null");
        return object.inSameDatabase(this.provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return provider.equals(provider);
    }

    @Override
    public boolean isLoaded() {
        return this.functionGraph != null;
    }

    @Override
    public boolean isOwner(IComment comment) {
        return CUserManager.get(this.provider).getCurrentActiveUser().equals(comment.getUser());
    }

    @Override
    public boolean isForwarded() {
        return this.forwardedFunctionAddress != null;
    }

    @Override
    public void load() throws CouldntLoadDataException {
        if (this.isLoaded()) {
            throw new IllegalStateException("IE00079: Function is already loaded");
        }
        try {
            if (!this.view.isLoaded()) {
                this.view.load();
            }
            this.functionGraph = this.convert((MutableDirectedGraph)this.view.getGraph());
        }
        catch (CPartialLoadException | LoadCancelledException e2) {
            CUtilityFunctions.logException(e2);
        }
        for (IFunctionListener<IComment> listener : this.functionListeners) {
            listener.loadedFunction(this);
        }
    }

    @Override
    public void removeListener(IFunctionListener<IComment> listener) {
        this.functionListeners.removeListener(listener);
    }

    @Override
    public void setDescription(String description) throws CouldntSaveDataException {
        this.setDescription(description, true);
    }

    @Override
    public void setDescriptionInternal(String description) {
        try {
            this.setDescription(description, false);
        }
        catch (CouldntSaveDataException couldntSaveDataException) {
            // empty catch block
        }
    }

    private void setDescription(String description, boolean saveToDatabase) throws CouldntSaveDataException {
        Preconditions.checkNotNull(description, "IE00080: New comment can not be null");
        if (description.equals(this.description)) {
            return;
        }
        if (saveToDatabase) {
            this.provider.setDescription(this, description);
        }
        this.description = description;
        for (IFunctionListener<IComment> listener : this.functionListeners) {
            listener.changedDescription(this, description);
        }
    }

    @Override
    public void setName(String name) throws CouldntSaveDataException {
        this.setName(name, true);
    }

    @Override
    public void setNameInternal(String name) {
        try {
            this.setName(name, false);
        }
        catch (CouldntSaveDataException couldntSaveDataException) {
            // empty catch block
        }
    }

    private void setName(String name, boolean saveToDatabase) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00085: Null is not a valid function name");
        if (name.equals(this.name)) {
            return;
        }
        if (saveToDatabase) {
            this.provider.setName(this, name);
        }
        this.name = name;
        for (IFunctionListener<IComment> listener : this.functionListeners) {
            listener.changedName(this, name);
        }
    }

    @Override
    public void setForwardedFunction(INaviFunction function) throws CouldntSaveDataException {
        Preconditions.checkNotNull(function, "Error: function arugment can not be null.");
        this.setForwardedFunction(function, true);
    }

    @Override
    public void removeForwardedFunction() throws CouldntSaveDataException {
        this.removeForwardedFunction(true);
    }

    @Override
    public void setForwardedFunctionInternal(INaviFunction function) {
        try {
            Preconditions.checkNotNull(function, "Error: function arugment can not be null.");
            this.setForwardedFunction(function, false);
        }
        catch (CouldntSaveDataException couldntSaveDataException) {
            // empty catch block
        }
    }

    @Override
    public void removeForwardedFunctionInternal() {
        try {
            this.removeForwardedFunction(false);
        }
        catch (CouldntSaveDataException couldntSaveDataException) {
            // empty catch block
        }
    }

    private void setForwardedFunction(INaviFunction function, boolean saveToDatabase) throws CouldntSaveDataException {
        Preconditions.checkArgument(CFunctionHelpers.isForwardableFunction(this), "IE00082: Only imported functions can be forwarded");
        Preconditions.checkNotNull(function, "Error: function argument can not be null");
        Preconditions.checkArgument(function.getType() != FunctionType.IMPORT, "IE00083: Imported functions can not be target functions");
        Preconditions.checkArgument(function.inSameDatabase(this.provider), "IE00084: Function and target function are not in the same database");
        if (function.getAddress().equals(this.forwardedFunctionAddress) && function.getModule().getConfiguration().getId() == this.forwardedFunctionModuleId) {
            return;
        }
        if (saveToDatabase) {
            this.provider.forwardFunction(this, function);
        }
        this.forwardedFunctionAddress = function.getAddress();
        this.forwardedFunctionModuleId = function.getModule().getConfiguration().getId();
        for (IFunctionListener<IComment> listener : this.functionListeners) {
            listener.changedForwardedFunction(this);
        }
    }

    private void removeForwardedFunction(boolean saveToDatabase) throws CouldntSaveDataException {
        if (this.forwardedFunctionAddress == null) {
            return;
        }
        if (saveToDatabase) {
            this.provider.forwardFunction(this, null);
        }
        this.forwardedFunctionAddress = null;
        this.forwardedFunctionModuleId = 0;
        for (IFunctionListener<IComment> listener : this.functionListeners) {
            listener.changedForwardedFunction(this);
        }
    }

    @Override
    public void setStackFrame(BaseType stackFrame) {
        this.stackFrame = stackFrame;
    }

    public String toString() {
        return String.format("Function %s: %s", this.address.toHexString(), this.name);
    }

    private class InternalCommentListener
    extends CommentListenerAdapter {
        private InternalCommentListener() {
        }

        @Override
        public void appendedGlobalFunctionComment(INaviFunction function, IComment comment) {
            if (CFunction.this == function) {
                for (IFunctionListener listener : CFunction.this.functionListeners) {
                    listener.appendedComment(function, comment);
                }
            }
        }

        @Override
        public void deletedGlobalFunctionComment(INaviFunction function, IComment comment) {
            if (CFunction.this == function) {
                for (IFunctionListener listener : CFunction.this.functionListeners) {
                    listener.deletedComment(function, comment);
                }
            }
        }

        @Override
        public void editedGlobalFunctionComment(INaviFunction function, IComment comment) {
            if (CFunction.this == function) {
                for (IFunctionListener listener : CFunction.this.functionListeners) {
                    listener.editedComment(function, comment);
                }
            }
        }

        @Override
        public void initializedGlobalFunctionComments(INaviFunction function, List<IComment> comments) {
            if (CFunction.this == function) {
                for (IFunctionListener listener : CFunction.this.functionListeners) {
                    listener.initializedComment(function, comments);
                }
            }
        }
    }
}

