/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CReferenceFinder;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.HashMap;

public final class CCodeNodeHelpers {
    private CCodeNodeHelpers() {
    }

    private static int getInstructionLineCount(INaviCodeNode codeNode, INaviInstruction instruction, INaviFunction function) {
        int count = 0;
        if (codeNode.getComments().getLocalInstructionComment(instruction) != null) {
            for (IComment comment : codeNode.getComments().getLocalInstructionComment(instruction)) {
                count += comment.getNumberOfCommentLines();
            }
        }
        if (instruction.getGlobalComment() != null) {
            for (IComment comment : instruction.getGlobalComment()) {
                count += comment.getNumberOfCommentLines();
            }
        }
        if (function != null && function.getGlobalComment() != null) {
            for (IComment comment : function.getGlobalComment()) {
                count += comment.getNumberOfCommentLines();
            }
        }
        return count == 0 ? 1 : count;
    }

    private static int getInitialLineCounter(INaviCodeNode codeNode) {
        try {
            codeNode.getParentFunction();
            return 1;
        }
        catch (MaybeNullException e2) {
            return 0;
        }
    }

    public static boolean containsAddress(INaviCodeNode codeNode, IAddress offset) {
        for (IInstruction instruction : codeNode.getInstructions()) {
            if (!instruction.getAddress().equals(offset)) continue;
            return true;
        }
        return false;
    }

    public static int getInstruction(INaviCodeNode codeNode, IAddress address) {
        int counter = 0;
        for (INaviInstruction instruction : codeNode.getInstructions()) {
            if (instruction.getAddress().equals(address)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public static int instructionToLine(INaviCodeNode codeNode, INaviInstruction instruction) {
        Preconditions.checkNotNull(instruction, "IE00059: Instruction argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02530: codeNode argument can not be null");
        int lineCounter = CCodeNodeHelpers.getInitialLineCounter(codeNode);
        HashMap<INaviInstruction, INaviFunction> functionMap = CReferenceFinder.getCodeReferenceMap(codeNode);
        for (INaviInstruction inst : codeNode.getInstructions()) {
            if (inst == instruction) {
                return lineCounter;
            }
            lineCounter += CCodeNodeHelpers.getInstructionLineCount(codeNode, inst, functionMap.get(inst));
        }
        throw new IllegalArgumentException("IE00060: Instruction is not part of the node");
    }

    public static INaviInstruction lineToInstruction(INaviCodeNode codeNode, int line) {
        Preconditions.checkArgument(line >= 0, "IE00061: Line number can not be negative");
        Preconditions.checkNotNull(codeNode, "IE01784: Code node argument can not be null");
        int lineCounter = CCodeNodeHelpers.getInitialLineCounter(codeNode);
        HashMap<INaviInstruction, INaviFunction> functionMap = CReferenceFinder.getCodeReferenceMap(codeNode);
        for (INaviInstruction instruction : codeNode.getInstructions()) {
            int instructionLines = CCodeNodeHelpers.getInstructionLineCount(codeNode, instruction, functionMap.get(instruction));
            if (line >= lineCounter && line < lineCounter + instructionLines) {
                return instruction;
            }
            lineCounter += instructionLines;
        }
        return null;
    }
}

