/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeComments;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNodeListener;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class CCodeNode
extends CNaviViewNode
implements INaviCodeNode {
    private final List<INaviInstruction> codeNodeInstructions = new ArrayList<INaviInstruction>();
    private final INaviFunction m_parentFunction;
    private final SQLProvider m_provider;
    private final CCodeNodeComments m_comments;
    private final ListenerProvider<INaviCodeNodeListener> m_listeners = new ListenerProvider();

    public CCodeNode(int nodeId, double x2, double y2, double width, double height, Color color, Color borderColor, boolean selected, boolean visible, List<IComment> localComment, INaviFunction parentFunction, Set<CTag> tags, SQLProvider provider) {
        super(nodeId, x2, y2, width, height, color, borderColor, selected, visible, tags, provider);
        this.m_parentFunction = parentFunction;
        this.m_provider = provider;
        this.m_comments = new CCodeNodeComments(this, this.m_parentFunction, localComment, this.m_listeners, this.m_provider);
    }

    @Override
    public void addInstruction(INaviInstruction instruction, List<IComment> localComment) {
        Preconditions.checkNotNull(instruction, "IE00056: Instruction argument can not be null");
        this.codeNodeInstructions.add(instruction);
        if (localComment != null) {
            this.m_comments.initializeLocalInstructionComment(instruction, localComment);
        }
        for (INaviCodeNodeListener listener : this.m_listeners) {
            try {
                listener.addedInstruction(this, instruction);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void addListener(INaviCodeNodeListener listener) {
        super.addListener(listener);
        this.m_listeners.addListener(listener);
    }

    @Override
    public CCodeNode cloneNode() {
        CCodeNode codeNode = new CCodeNode(-1, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getColor(), this.getBorderColor(), this.isSelected(), this.isVisible(), this.m_comments.getLocalCodeNodeComment(), this.m_parentFunction, this.getTags(), this.m_provider);
        for (INaviInstruction instruction : this.codeNodeInstructions) {
            codeNode.addInstruction(instruction.cloneInstruction(), this.m_comments.getLocalInstructionComment(instruction));
        }
        return codeNode;
    }

    @Override
    public void close() {
        super.close();
        for (INaviInstruction instruction : this.codeNodeInstructions) {
            instruction.close();
            CommentManager.get(this.m_provider).unloadLocalnstructionComment(this, instruction, this.m_comments.getLocalInstructionComment(instruction));
        }
        this.m_comments.dispose();
    }

    @Override
    public IAddress getAddress() {
        return this.codeNodeInstructions.get(0).getAddress();
    }

    @Override
    public CCodeNodeComments getComments() {
        return this.m_comments;
    }

    @Override
    public Iterable<INaviInstruction> getInstructions() {
        return this.codeNodeInstructions;
    }

    @Override
    public INaviInstruction getLastInstruction() {
        return this.codeNodeInstructions.isEmpty() ? null : this.codeNodeInstructions.get(this.codeNodeInstructions.size() - 1);
    }

    @Override
    public INaviFunction getParentFunction() throws MaybeNullException {
        if (this.m_parentFunction == null) {
            throw new MaybeNullException();
        }
        return this.m_parentFunction;
    }

    @Override
    public boolean hasInstruction(INaviInstruction instruction) {
        return this.codeNodeInstructions.contains(instruction);
    }

    @Override
    public int instructionCount() {
        return this.codeNodeInstructions.size();
    }

    @Override
    public boolean isOwner(IComment comment) {
        return CUserManager.get(this.m_provider).getCurrentActiveUser().equals(comment.getUser());
    }

    @Override
    public void removeInstruction(INaviInstruction instruction) {
        Preconditions.checkNotNull(instruction, "IE00062: Instruction argument can not be null");
        Preconditions.checkArgument(this.codeNodeInstructions.contains(instruction), "IE00063: Instruction is not part of this node");
        this.codeNodeInstructions.remove(instruction);
        for (INaviCodeNodeListener listener : this.m_listeners) {
            try {
                listener.removedInstruction(this, instruction);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void removeListener(INaviCodeNodeListener listener) {
        super.removeListener(listener);
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void setInstructionColor(INaviInstruction instruction, int level, Color color) {
        Preconditions.checkNotNull(instruction, "IE01264: Instruction argument can not be null");
        Preconditions.checkArgument(this.codeNodeInstructions.contains(instruction), "IE01276: Instruction does not belong to the code node");
        for (INaviCodeNodeListener listener : this.m_listeners) {
            try {
                listener.changedInstructionColor(this, instruction, level, color);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public String toString() {
        int n2 = this.getId();
        StringBuilder description = new StringBuilder(new StringBuilder(22).append("Code Node ").append(n2).append("\n").toString());
        for (IInstruction iInstruction : this.codeNodeInstructions) {
            description.append("  ");
            description.append(iInstruction.toString());
            description.append('\n');
        }
        return description.toString();
    }
}

