/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import java.util.ArrayList;
import java.util.List;

public final class CCallgraphNode
implements ICallgraphNode {
    private final INaviFunction m_function;
    private final List<ICallgraphNode> m_parents = new ArrayList<ICallgraphNode>();
    private final List<ICallgraphNode> m_children = new ArrayList<ICallgraphNode>();

    public CCallgraphNode(INaviFunction function) {
        this.m_function = Preconditions.checkNotNull(function, "IE01235: Function argument can not be null");
    }

    public static void link(CCallgraphNode parent, CCallgraphNode child) {
        Preconditions.checkNotNull(parent, "IE01236: Parent argument can not be null");
        Preconditions.checkNotNull(child, "IE01237: Child argument can not be null");
        parent.m_children.add(child);
        child.m_parents.add(parent);
    }

    @Override
    public List<ICallgraphNode> getChildren() {
        return new ArrayList<ICallgraphNode>(this.m_children);
    }

    @Override
    public INaviFunction getFunction() {
        return this.m_function;
    }

    @Override
    public List<ICallgraphNode> getParents() {
        return new ArrayList<ICallgraphNode>(this.m_parents);
    }
}

