/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphEdge;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.zylib.types.graphs.DirectedGraph;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CCallgraph
extends DirectedGraph<ICallgraphNode, ICallgraphEdge> {
    private ImmutableMap<INaviFunction, ICallgraphNode> m_functionMap;

    public CCallgraph(List<ICallgraphNode> nodes, List<ICallgraphEdge> edges) {
        super(nodes, edges);
        this.m_functionMap = Maps.uniqueIndex(nodes, new Function<ICallgraphNode, INaviFunction>(){

            @Override
            public INaviFunction apply(ICallgraphNode input) {
                return input.getFunction();
            }
        });
    }

    private Set<INaviFunction> getFunctions(Iterable<? extends ICallgraphNode> nodes) {
        HashSet<INaviFunction> functions = new HashSet<INaviFunction>();
        for (ICallgraphNode iCallgraphNode : nodes) {
            functions.add(iCallgraphNode.getFunction());
        }
        return functions;
    }

    public Set<INaviFunction> getCallers(INaviFunction calledFunction) {
        ICallgraphNode node = this.m_functionMap.get(calledFunction);
        return this.getFunctions(node.getParents());
    }
}

