/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.CFunctionEdge;
import com.google.security.zynamics.binnavi.disassembly.IBlockNode;
import com.google.security.zynamics.binnavi.disassembly.INaviBasicBlock;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.ArrayList;
import java.util.List;

public final class CBlockNode
implements IBlockNode {
    private final INaviBasicBlock m_block;
    private final List<IBlockNode> m_parents = new ArrayList<IBlockNode>();
    private final List<IBlockNode> m_children = new ArrayList<IBlockNode>();
    private final List<CFunctionEdge> m_outgoingEdges = new ArrayList<CFunctionEdge>();

    public CBlockNode(INaviBasicBlock block) {
        this.m_block = Preconditions.checkNotNull(block, "IE01231: Block argument can not be null");
    }

    public static void link(CFunctionEdge edge, CBlockNode parent, CBlockNode child) {
        parent.m_outgoingEdges.add(Preconditions.checkNotNull(edge, "IE01232: Edge argument can not be null"));
        parent.m_children.add(Preconditions.checkNotNull(parent, "IE01233: Parent argument can not be null"));
        child.m_parents.add(Preconditions.checkNotNull(child, "IE01234: Child argument can not be null"));
    }

    @Override
    public IAddress getAddress() {
        return this.m_block.getAddress();
    }

    @Override
    public INaviBasicBlock getBlock() {
        return this.m_block;
    }

    @Override
    public List<IBlockNode> getChildren() {
        return new ArrayList<IBlockNode>(this.m_children);
    }

    @Override
    public Iterable<INaviInstruction> getInstructions() {
        return this.m_block.getInstructions();
    }

    @Override
    public INaviInstruction getLastInstruction() {
        List<INaviInstruction> instructions = this.m_block.getInstructions();
        return instructions.isEmpty() ? null : instructions.get(instructions.size() - 1);
    }

    @Override
    public List<CFunctionEdge> getOutgoingEdges() {
        return new ArrayList<CFunctionEdge>(this.m_outgoingEdges);
    }

    @Override
    public List<IBlockNode> getParents() {
        return new ArrayList<IBlockNode>(this.m_parents);
    }

    @Override
    public boolean hasInstruction(INaviInstruction instruction) {
        return this.m_block.getInstructions().contains(instruction);
    }
}

