/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.AddressSpaces;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.AddressSpaceConfigurationBackend;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.ProjectTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.TcpDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceConfigurationListener;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.Date;

public final class CAddressSpaceConfiguration {
    private final ListenerProvider<IAddressSpaceConfigurationListener> m_listeners = new ListenerProvider();
    private final CAddressSpace m_addressSpace;
    private final AddressSpaceConfigurationBackend m_provider;
    private final int m_id;
    private String m_name;
    private String m_description;
    private final Date m_creationDate;
    private Date m_modificationDate;
    private DebuggerTemplate m_debuggerTemplate = null;
    private IDebugger m_debugger = null;

    public CAddressSpaceConfiguration(CAddressSpace addressSpace, AddressSpaceConfigurationBackend provider, int addressSpaceId, String name, String description, Date creationDate, Date modificationDate, DebuggerTemplate debuggerTemplate) {
        this.m_addressSpace = addressSpace;
        this.m_provider = provider;
        this.m_id = addressSpaceId;
        this.m_name = name;
        this.m_description = description;
        this.m_creationDate = new Date(creationDate.getTime());
        this.m_modificationDate = new Date(modificationDate.getTime());
        this.m_debuggerTemplate = debuggerTemplate;
    }

    private void updateDebugger(DebuggerTemplate template) {
        if (this.m_addressSpace.isLoaded() && (this.m_debugger == null || !this.m_debugger.isConnected())) {
            if (template == null) {
                this.m_debugger = null;
            } else {
                this.m_debugger = new TcpDebugger(template, new ProjectTargetSettings(this.m_addressSpace.getProject()));
                for (INaviModule module : this.m_addressSpace.getContent().getModules()) {
                    this.m_debugger.setAddressTranslator(module, module.getConfiguration().getFileBase(), this.m_addressSpace.getContent().getImageBase(module));
                }
            }
        }
    }

    public void addListener(IAddressSpaceConfigurationListener listener) {
        this.m_listeners.addListener(listener);
    }

    public Date getCreationDate() {
        return new Date(this.m_creationDate.getTime());
    }

    public IDebugger getDebugger() {
        return this.m_debugger;
    }

    public DebuggerTemplate getDebuggerTemplate() {
        return this.m_debuggerTemplate;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getId() {
        return this.m_id;
    }

    public Date getModificationDate() {
        return new Date(this.m_modificationDate.getTime());
    }

    public String getName() {
        return this.m_name;
    }

    public void removeListener(IAddressSpaceConfigurationListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setDebugger(TcpDebugger debugger) {
        this.m_debugger = debugger;
    }

    public void setDebuggerTemplate(DebuggerTemplate template) throws CouldntSaveDataException {
        this.m_provider.assignDebugger(this.m_addressSpace, template);
        this.m_debuggerTemplate = template;
        this.m_addressSpace.getConfiguration().updateDebugger(this.m_debuggerTemplate);
        for (IAddressSpaceConfigurationListener listener : this.m_listeners) {
            try {
                listener.changedDebugger(this.m_addressSpace, template);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(description, "IE00044: Description argument can not be null");
        if (this.m_description.equals(description)) {
            return;
        }
        this.m_provider.setDescription(this.m_addressSpace, description);
        this.m_description = description;
        for (IAddressSpaceConfigurationListener listener : this.m_listeners) {
            try {
                listener.changedDescription(this.m_addressSpace, description);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    public void setName(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00049: Name argument can not be null");
        if (this.m_name.equals(name)) {
            return;
        }
        this.m_provider.setName(this.m_addressSpace, name);
        this.m_name = name;
        for (IAddressSpaceConfigurationListener listener : this.m_listeners) {
            try {
                listener.changedName(this.m_addressSpace, name);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    public void updateModificationDate() {
        try {
            this.m_modificationDate = this.m_provider.getModificationDate(this.m_addressSpace);
            for (IAddressSpaceConfigurationListener listener : this.m_listeners) {
                try {
                    listener.changedModificationDate(this.m_addressSpace, this.m_modificationDate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
        catch (CouldntLoadDataException e2) {
            CUtilityFunctions.logException(e2);
        }
    }
}

