/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.trace;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListListener;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class TraceList
implements Iterable<ITraceEvent>,
IDatabaseObject {
    private final int id;
    private String traceName;
    private String traceDescription;
    private final List<ITraceEvent> traceEvents = new ArrayList<ITraceEvent>();
    private final ListenerProvider<ITraceListListener> listeners = new ListenerProvider();
    private final SQLProvider sqlProvider;

    public TraceList(int id, String name, String description, SQLProvider provider) {
        Preconditions.checkArgument(id >= 0, "IE00777: ID argument can not be null");
        this.traceName = Preconditions.checkNotNull(name, "IE00778: Name can not be null");
        this.traceDescription = Preconditions.checkNotNull(description, "IE00779: Comment can not be null");
        this.sqlProvider = Preconditions.checkNotNull(provider, "IE00780: Provider argument can not be null");
        this.id = id;
    }

    public void addEvent(ITraceEvent event) {
        Preconditions.checkNotNull(event, "IE00781: Trace event can not be null");
        if (this.traceEvents.contains(event)) {
            throw new IllegalStateException("IE00782: Trace event already belongs to the trace list");
        }
        this.traceEvents.add(event);
        for (ITraceListListener listener : this.listeners) {
            try {
                listener.eventAdded(this, event);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void addListener(ITraceListListener listener) {
        this.listeners.addListener(listener);
    }

    public String getDescription() {
        return this.traceDescription;
    }

    public int getEventCount() {
        return this.traceEvents.size();
    }

    public List<ITraceEvent> getEvents() {
        return new ArrayList<ITraceEvent>(this.traceEvents);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.traceName;
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject provider) {
        return provider.inSameDatabase(this.sqlProvider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return provider.equals(this.sqlProvider);
    }

    @Override
    public Iterator<ITraceEvent> iterator() {
        return this.traceEvents.iterator();
    }

    public void removeListener(ITraceListListener listener) {
        this.listeners.removeListener(listener);
    }

    public void save() throws CouldntSaveDataException {
        this.sqlProvider.save(this);
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(description, "IE00783: Comment can not be null");
        if (this.traceDescription.equals(description)) {
            return;
        }
        this.sqlProvider.setDescription(this, description);
        this.traceDescription = description;
        for (ITraceListListener listener : this.listeners) {
            try {
                listener.changedDescription(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00784: Name can not be null");
        if (this.traceName.equals(name)) {
            return;
        }
        this.sqlProvider.setName(this, name);
        this.traceName = name;
        for (ITraceListListener listener : this.listeners) {
            try {
                listener.changedName(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

