/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.trace;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceEventType;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceRegister;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import java.util.List;

public final class TraceEvent
implements ITraceEvent {
    private final long traceEventSourceThreadId;
    private final BreakpointAddress traceEventBreakpointAddress;
    private final TraceEventType traceEventType;
    private final ImmutableList<TraceRegister> traceValues;

    public TraceEvent(long tid, BreakpointAddress address, TraceEventType type, List<TraceRegister> values) {
        this.traceEventBreakpointAddress = Preconditions.checkNotNull(address, "IE00775: Address argument can not be null");
        this.traceEventType = Preconditions.checkNotNull(type, "IE00776: Type argument can not be null");
        this.traceEventSourceThreadId = tid;
        this.traceValues = ImmutableList.copyOf(values);
    }

    @Override
    public BreakpointAddress getOffset() {
        return this.traceEventBreakpointAddress;
    }

    @Override
    public long getThreadId() {
        return this.traceEventSourceThreadId;
    }

    @Override
    public TraceEventType getType() {
        return this.traceEventType;
    }

    public ImmutableList<TraceRegister> getRegisterValues() {
        return this.traceValues;
    }
}

