/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.targetinformation;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerOptions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class TargetInformation {
    private final int targetPlatformAddressByteSize;
    private final List<RegisterDescription> registerDescriptions;
    private final DebuggerOptions debuggerOptions;

    public TargetInformation(int addressSize, List<RegisterDescription> registers, DebuggerOptions debuggerOptions) {
        Preconditions.checkArgument(addressSize > 0, "IE01039: Address size value must be positive");
        this.registerDescriptions = new ArrayList<RegisterDescription>((Collection)Preconditions.checkNotNull(registers, "IE01303: Registers argument can not be null"));
        this.debuggerOptions = Preconditions.checkNotNull(debuggerOptions, "IE01306: Debugger options argument can not be null");
        this.targetPlatformAddressByteSize = addressSize;
    }

    public int getAddressSize() {
        return this.targetPlatformAddressByteSize;
    }

    public DebuggerOptions getDebuggerOptions() {
        return this.debuggerOptions;
    }

    public List<RegisterDescription> getRegisters() {
        return new ArrayList<RegisterDescription>(this.registerDescriptions);
    }
}

