/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.targetinformation;

import com.google.common.base.Preconditions;
import java.math.BigInteger;

public final class RegisterValue {
    private final String name;
    private final BigInteger value;
    private final byte[] memoryPointedTo;
    private final boolean isProgramCounter;
    private final boolean isStackPointer;

    public RegisterValue(String name, BigInteger value, byte[] memory, boolean isPc, boolean isSp) {
        this.name = Preconditions.checkNotNull(name, "IE01047: Name argument can not be null");
        this.value = Preconditions.checkNotNull(value, "IE01033: Value argument can not be null");
        Preconditions.checkArgument(!isPc || !isSp, "IE01034: A register can not be both program counter register and stack register");
        this.memoryPointedTo = (byte[])memory.clone();
        this.isProgramCounter = isPc;
        this.isStackPointer = isSp;
    }

    public byte[] getMemory() {
        return (byte[])this.memoryPointedTo.clone();
    }

    public String getName() {
        return this.name;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public boolean isPc() {
        return this.isProgramCounter;
    }

    public boolean isSp() {
        return this.isStackPointer;
    }
}

